<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <title>Fn y Codigo SIG</title>
</head>

<body>
    @include('layout.header')

    <div class="container w-11/12 mx-auto py-12">

        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-3 sm:grid-cols-2">

            <div>
                <form id="Fnsubido" action="{{ route('sig.store') }}" method="post">
                    @csrf
                    <h2 class="text-center font-semibold leading-7 text-gray-900">FN | CODIGO SIG</h2>
                    <label for="fn" class="block text-sm font-medium leading-6 text-gray-900">Fn
                        <strong class=" text-red-600">*</strong></label>
                    <div class="mt-2">
                        <input type="text" name="fn" id="fn" autocomplete="off" required
                            placeholder="ej: FN12345"
                            class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                    </div>

                    <label for="codigo" class="block text-sm font-medium leading-6 text-gray-900">Codigo SIG
                        <strong class=" text-red-600">*</strong></label>
                    <div class="mt-2">
                        <input type="text" name="codigo" id="codigo" autocomplete="off" required
                            placeholder="ej: CO123456 o 1234567"
                            class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                    </div>

                    <div class="mt-6 flex items-center justify-end ">
                        <button type="submit"
                            class="rounded-md bg-red-800 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">
                            Registrar</button>
                    </div>
                </form>

                <form id="mensajeSig" action="{{ route('sig.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    {{-- <h2 class="text-center font-semibold text-gray-900 text-lg">Importar Archivo FN</h2> --}}
                    <div class="flex flex-col items-center justify-center">
                        <label for="fn_sig" class="block text-sm font-medium text-gray-700">Subir Archivo
                            CSV</label>
                        <input id="fn_sig" type="file" name="fn_sig" required
                            class="mt-2 block w-full text-sm text-gray-700 bg-white border border-gray-300 rounded-lg cursor-pointer focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-red-500 file:text-white hover:file:bg-red-600" />
                    </div>
                    <div class="flex justify-end">
                        <button type="submit"
                            class="mt-4 rounded-md bg-red-800 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">
                            Importar FN
                        </button>
                    </div>
                </form>

                <i class="fa-solid fa-arrow-right"></i>
                <a href="{{ asset('plantillas/sig.csv') }}" target="_blank"
                    class="text-blue-600 hover:underline dark:text-blue-500">Plantilla de
                    Importación codigo sig</a>
            </div>

            <div>
                <div class="mt-8 overflow-x-auto">
                    <div class="form-group col-md-5 col-md-offset-7">
                        <input type="text" id="FnBuscar" placeholder="Fn | Codigo SIG"
                            class="mt-2 block w-full max-w-xs text-sm text-gray-900 bg-gray-50 rounded-md border border-gray-300 cursor-pointer focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-600 p-2">
                    </div>
                    <h3 class="text-xl font-semibold mb-4">LISTADO FN Y SIG</h3>
                    <div id="divTablefn">
                        @include('partials.tableSig')
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="{{ asset('js/fn_sig.js') }}"></script>
</body>

</html>
