<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    <title>crear</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    {{-- <link rel="stylesheet" href="fontawesome/css/all.min.css"> --}}
    <link rel="stylesheet" href="{{ asset('fontawesome/css/all.min.css') }}">
</head>

<body>
    @include('layout.header')

    <div class="container mx-auto px-4 py-6">
        <h1 class="text-2xl font-bold mb-4">Crear Nueva Encuesta</h1>

        <form action="{{ route('hse.guardar') }}" method="POST" id="actualizarform" class="bg-white shadow-md rounded px-8 pt-6 pb-8 mb-4" enctype="multipart/form-data">
            @csrf

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Título</label>
                <input type="text" name="titulo"
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700" required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Descripción</label>
                <textarea name="descripcion" rows="3"
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700"></textarea>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Categoría</label>
                <select name="categoria" class="shadow border rounded w-full py-2 px-3 text-gray-700" required>
                    <option value="">-- Seleccione --</option>
                    @foreach ($categorias as $categoria)
                        <option value="{{ $categoria }}">{{ $categoria }}</option>
                    @endforeach
                </select>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Frecuencia</label>
                <select name="frecuencia" class="shadow border rounded w-full py-2 px-3 text-gray-700" required>
                    <option value="">-- Seleccione Frecuencia --</option>
                    <option value="única">Única vez</option>
                    <option value="mensual">Una vez al mes</option>
                    <option value="varias">Varias veces al mes</option>
                </select>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Adjuntar imagen (opcional)</label>
                <input type="file" name="file" id="" accept="image/*">
                <br>
                @error('file')
                    <p class="text-red-600 text-sm mt-1 font-semibold">Error: {{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label class="inline-flex items-center">
                    <input type="checkbox" name="activa" value="1" class="form-checkbox text-indigo-600" checked>
                    <span class="ml-2 text-gray-700">Encuesta activa</span>
                </label>
            </div>

           <!--  <div class="mb-4">
                <label class="inline-flex items-center">
                    <input type="checkbox" name="imageAct" value="0" class="form-checkbox text-indigo-600" checked>
                    <span class="ml-2 text-gray-700">Permitir imagenes</span>
                </label>
            </div> -->

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Preguntas</label>
                <div id="preguntasContainer">
                    <!-- Contenedor de preguntas dinámicas -->
                </div>

                <button type="button" id="agregarPregunta"
                    class="mt-2 bg-green-600 text-white px-3 py-1 rounded hover:bg-green-500">
                    Agregar Pregunta
                </button>
            </div>

            <!-- Plantilla oculta para duplicar -->
            <template id="preguntaTemplate">
                <div class="pregunta mb-4 border p-3 rounded bg-gray-50" data-index="">
                    <label class="block text-sm font-bold mb-1">Texto de la Pregunta</label>
                    <input type="text" name="preguntas[][texto]" class="w-full border px-2 py-1 rounded mb-2"
                        required>

                    <label class="block text-sm font-bold mb-1">Tipo</label>
                    <select name="preguntas[][tipo]" class="w-full border px-2 py-1 rounded tipoPregunta" required>
                        <option value="">-- Seleccione Tipo --</option>
                        <option value="texto">Texto</option>
                        <option value="opcion">Opción</option>
                        <option value="seleccion_multiple">Selección Múltiple</option>
                        <option value="fecha">Fecha</option>
                        <option value="imagen">Imagen</option>
                        <option value="datos_personales">Datos Personales</option>
                    </select>
                    <label class="block text-sm font-bold mb-1">Valor de la pregunta</label>
                    <input type="number" name="preguntas[][valor]" min="0" max="100" value="0" class="w-full border px-2 py-1 rounded mb-2">
                     <div class="datosPersonalesContainer mt-2 hidden">
                        <label class="block text-sm font-bold mb-1">Selecciona un dato personal:</label>
                        <div class="space-y-1 pl-2">
                            <label><input type="radio" name="dato_personal" value="Nombre y Apellido" class="datoRadio"> Nombre y Apellido</label><br>
                            <label><input type="radio" name="dato_personal" value="Correo" class="datoRadio"> Correo</label><br>
                            <label><input type="radio" name="dato_personal" value="Cargo" class="datoRadio"> Cargo</label><br>
                            <label><input type="radio" name="dato_personal" value="ODS" class="datoRadio"> ODS</label><br>
                            <label><input type="radio" name="dato_personal" value="Ubicación" class="datoRadio"> Ubicación</label>
                        </div>
                    </div>


                    <!-- Contenedor dinámico para las opciones -->
                    <div class="opcionesContainer mt-2 hidden">
                        <label class="block text-sm font-bold mb-1">Opciones</label>
                        <div class="listaOpciones space-y-2"></div>
                        <button type="button" class="agregarOpcion mt-2 text-blue-600 hover:underline text-sm">+
                            Agregar Opción</button>
                        <button type="button" class="agregarOpcionOtro mt-1 text-purple-600 hover:underline text-sm">
                            + Agregar opcion "Otro" </button>
                    </div>

                    <button type="button" class="mt-2 text-red-600 eliminarPregunta hover:underline">Eliminar</button>
                </div>
            </template>


            <div class="flex items-center justify-between">
                <button type="submit" class="bg-red-900 text-white font-bold py-2 px-4 rounded hover:bg-red-700">
                    Guardar Encuesta
                </button>
            </div>
        </form>
    </div>

    <script>
        let preguntaIndex = 0;

        document.getElementById('agregarPregunta').addEventListener('click', function() {
            const template = document.getElementById('preguntaTemplate');
            const clone = template.content.cloneNode(true);

            // Establece nombres únicos
            const pregunta = clone.querySelector('.pregunta');
            pregunta.setAttribute('data-index', preguntaIndex);

            const textoInput = pregunta.querySelector('input[name="preguntas[][texto]"]');
            const tipoSelect = pregunta.querySelector('select[name="preguntas[][tipo]"]');
            const tipoValor = pregunta.querySelector('input[name="preguntas[][valor]"]');            
            textoInput.name = `preguntas[${preguntaIndex}][texto]`;
            tipoSelect.name = `preguntas[${preguntaIndex}][tipo]`;
            tipoValor.name = `preguntas[${preguntaIndex}][valor]`;

            document.getElementById('preguntasContainer').appendChild(clone);
            preguntaIndex++;
        });

        // Delegación de eventos para eliminar pregunta
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('eliminarPregunta')) {
                e.target.closest('.pregunta').remove();
            }

            // Agregar opción
            if (e.target.classList.contains('agregarOpcion')) {
                const pregunta = e.target.closest('.pregunta');
                const index = pregunta.dataset.index;
                const lista = pregunta.querySelector('.listaOpciones');
                const opcionIndex = lista.children.length;

                const opcion = document.createElement('div');
                opcion.classList.add('flex', 'items-center', 'gap-2');
                opcion.innerHTML = `
                <input type="text" name="preguntas[${index}][opciones][${opcionIndex}][texto]"
                    class="border px-2 py-1 rounded w-full" placeholder="Opción">
                <input type="number" name="preguntas[${index}][opciones][${opcionIndex}][valor]"
                    min="0" max="100" value="0" class="border px-2 py-1 rounded w-20 text-center">
                <button type="button" class="text-red-600 eliminarOpcion hover:underline">Eliminar</button>`;
                lista.appendChild(opcion);
            }
            if (e.target.classList.contains('agregarOpcionOtro')) {
                const pregunta = e.target.closest('.pregunta');
                const index = pregunta.dataset.index;
                const lista = pregunta.querySelector('.listaOpciones');
                const opcionIndex = lista.children.length;

                const opcion = document.createElement('div');
                opcion.classList.add('flex', 'items-center', 'gap-2');
                opcion.innerHTML = `
                    <input type="text" name="preguntas[${index}][opciones][${opcionIndex}][texto]"
                    class="border px-2 py-1 rounded w-full bg-gray-200 text-gray-700" 
                    value="Otro" readonly>
                    <input type="number" name="preguntas[${index}][opciones][${opcionIndex}][valor]"
                    min="0" max="100" value="0"
                    class="border px-2 py-1 rounded w-20 text-center">
                    <button type="button" class="text-red-600 eliminarOpcion hover:underline">Eliminar</button>`;
                lista.appendChild(opcion);
            }

            // Eliminar opción
            if (e.target.classList.contains('eliminarOpcion')) {
                e.target.closest('div').remove();
            }
        });

        // Mostrar opciones solo si el tipo lo requiere
        document.addEventListener('change', function(e) {
            if (e.target.classList.contains('tipoPregunta')) {
                const pregunta = e.target.closest('.pregunta');
                const contenedorOpciones = pregunta.querySelector('.opcionesContainer');
                const tipo = e.target.value;

                if (tipo === 'opcion' || tipo === 'seleccion_multiple') {
                    contenedorOpciones.classList.remove('hidden');
                } else {
                    contenedorOpciones.classList.add('hidden');
                    pregunta.querySelector('.listaOpciones').innerHTML = '';
                }
            }
        });
    </script>
    <script>
        
        document.addEventListener('change', function(e) {
            // Si se selecciona tipo de pregunta
            if (e.target.classList.contains('tipoPregunta')) {
                const pregunta = e.target.closest('.pregunta');
                const tipo = e.target.value;
                const contenedorOpciones = pregunta.querySelector('.opcionesContainer');
                const contenedorDatosPersonales = pregunta.querySelector('.datosPersonalesContainer');

                if (tipo === 'opcion' || tipo === 'seleccion_multiple') {
                    contenedorOpciones.classList.remove('hidden');
                    contenedorDatosPersonales.classList.add('hidden');
                } else if (tipo === 'datos_personales') {
                    contenedorOpciones.classList.add('hidden');
                    contenedorDatosPersonales.classList.remove('hidden');
                } else {
                    contenedorOpciones.classList.add('hidden');
                    contenedorDatosPersonales.classList.add('hidden');
                }
            }

            // Si se selecciona un dato personal
            if (e.target.classList.contains('datoRadio')) {
                const pregunta = e.target.closest('.pregunta');
                const inputTexto = pregunta.querySelector('input[type="text"]');
                inputTexto.value = e.target.value; // Sobrescribe lo que haya
            }
        });


    </script>

</body>

</html>
