<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    <title>inicio</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    {{-- <link rel="stylesheet" href="fontawesome/css/all.min.css"> --}}
    <link rel="stylesheet" href="{{ asset('fontawesome/css/all.min.css') }}">
</head>

<body>
    @include('layout.header')

    <div class="p-6">
        <h2 class="text-2xl font-bold mb-4">Encuestas de {{ ucfirst($categoria) }}</h2>

        <div class="grid grid-cols-1 md:grid-cols-1 lg:grid-cols-1 gap-3">
            @foreach ($encuestas as $encuesta)
                <div class="bg-white border p-4 rounded shadow hover:shadow-lg transition">
                    <h3 class="text-lg font-semibold">{{ $encuesta->titulo }}</h3>
                    <p class="text-sm text-gray-600 mb-2">{{ $encuesta->descripcion }}</p>

                    @php
                        $respuestaQuery = \App\Models\Respuesta::where('encuesta_id', $encuesta->id)->where(
                            'user_id',
                            auth()->id(),
                        );

                        switch ($encuesta->frecuencia) {
                            case 'única':
                                $yaRespondida = $respuestaQuery->exists();
                                break;
                            case 'mensual':
                                $yaRespondida = $respuestaQuery
                                    ->whereMonth('created_at', now()->month)
                                    ->whereYear('created_at', now()->year)
                                    ->exists();
                                break;
                            case 'varias':
                                $yaRespondida = false;
                                break;
                            default:
                                $yaRespondida = false;
                        }
                    @endphp

                    @if (!$yaRespondida)
                        <a href="{{ route('encuesta.responder', $encuesta->id) }}"
                            class="inline-block bg-red-700 text-white px-4 py-2 rounded mt-2">Responder</a>
                    @else
                        <span class="inline-block bg-gray-400 text-white px-4 py-2 rounded mt-2 cursor-not-allowed">Ya
                            respondida</span>
                    @endif

                </div>
            @endforeach
        </div>
    </div>
</body>

</html>
