<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            padding: 30px;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            margin: 0 auto;
            background-color: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        th, td {
            border: 1px solid #ddd;
            padding: 12px 15px;
            text-align: left;
            vertical-align: top; /* Alineación arriba */
        }

        th {
            background-color: #f0f0f0;
            font-weight: bold;
        }

        tr:nth-child(even) {
            background-color: #fafafa;
        }

        h1 {
            text-align: center;
            margin-bottom: 20px;
        }
    </style>
</head>
    
<body>
        <table class="table-auto w-full text-left border border-gray-300">
            <thead class="bg-gray-200">
                <tr>
                    <th class="px-4 py-2 border align-top">Título: {{ $encuesta->titulo }}</th>
                    <th class="px-4 py-2 border align-top">Descripción: {{ $encuesta->descripcion }}</th>
                    <th class="px-4 py-2 border align-top">Frecuencia: {{ $encuesta->frecuencia }}</th>
                    <th class="px-4 py-2 border align-top">Categoría: {{ $encuesta->categoria}}</th>
                </tr>
            </thead>
        </table>
    <table>
        <thead>
            <tr>
                <th>Usuario</th>
                @foreach ($preguntas as $pregunta)
                    <th>{{ $pregunta->texto }}</th>
                @endforeach
                <th>Fecha</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($respuestas as $user_id => $respuestasUsuario)
                <tr>
                   <td>{{ $respuestasUsuario->first()->usuario->name }}</td>

                    @foreach ($preguntas as $pregunta)
                        @php
                            $respuesta = $respuestasUsuario->firstWhere('pregunta_id', $pregunta->id);
                        @endphp

                        <td>
                            @if ($respuesta)
                                @if ($respuesta->url)
                                    <img src="{{ asset($respuesta->url) }}" alt="Imagen"  >
                                @elseif($respuesta->respuesta_texto)
                                    {{ $respuesta->respuesta_texto }}
                                @else
                                    -
                                @endif
                            @else
                                -
                            @endif
                        </td>
                    @endforeach

                    <td>{{ $respuestasUsuario->first()->created_at->format('Y-m-d H:i') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>