<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    <title>inicio</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    {{-- <link rel="stylesheet" href="fontawesome/css/all.min.css"> --}}
    <link rel="stylesheet" href="{{ asset('fontawesome/css/all.min.css') }}">
</head>

<body>
    @include('layout.header')

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 p-6">
       @foreach ($encuestasAgrupadas as $categoria => $encuestas)
            @if ($encuestas->count() > 0)
                @php
                    $imagenes = [
                        'actos y condiciones inseguras' => 'Seguridad.png',
                        'conversaciones y reflexiones' => 'Conversaciones.png',
                        'momento hse' => 'Momento.png',
                        'campañas' => 'Campaña.png',
                        'alertas hse ecp' => 'Alerta.png',
                        'capacitaciones' => 'Capacitaciones.jpg',
                    ];

                    $nombreCategoria = strtolower($categoria);
                    $imagen = $imagenes[$nombreCategoria] ?? 'default.png'; // Imagen por defecto si no hay coincidencia
                @endphp

                <a href="{{ route('encuestas.categoria', ['categoria' => $categoria]) }}">
                    <div class="bg-gray-100 border hover:shadow-xl transition rounded-2xl p-6 cursor-pointer text-center">
                        <img src="{{ asset('images/' . $imagen) }}" alt="{{ $categoria }}" class="mx-auto mb-3 w-16 h-16 object-contain">
                        <h3 class="text-lg font-bold text-gray-700">{{ $categoria }}</h3>
                        <p class="text-sm text-gray-600">{{ $encuestas->count() }} encuesta(s) disponible(s)</p>
                    </div>
                </a>
            @endif
        @endforeach

    </div>

</body>

</html>
