<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    <title>Responder</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    {{-- <link rel="stylesheet" href="fontawesome/css/all.min.css"> --}}
    <link rel="stylesheet" href="{{ asset('fontawesome/css/all.min.css') }}">
</head>

<body class="bg-gray-100 min-h-screen">
    @include('layout.header')

    <div class="max-w-2xl mx-auto mt-10 bg-white p-8 rounded shadow-md">
        <h2 class="text-2xl font-bold text-gray-800 mb-1">{{ $encuesta->titulo }}</h2>
        <p class="text-gray-600 text-sm mb-6">{{ $encuesta->descripcion }}</p>
        @if($encuesta->url  && $encuesta->url !== 'null')
            <img src="{{ $encuesta->url }}" alt="Imagen de la encuesta" class="mx-auto max-h-80 w-auto">
        @endif      
        <form action="{{ route('encuesta.guardar', $encuesta->id) }}" method="POST" class="space-y-6" enctype="multipart/form-data">

            @csrf

            @if ($encuesta->preguntas->isEmpty())
                <p class="text-red-600 font-semibold">Esta encuesta no tiene preguntas.</p>
            @endif
            @foreach ($encuesta->preguntas as $pregunta)
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-2">{{ $pregunta->texto }}</label>

                    @if ($pregunta->tipo == 'texto')
                        <input type="text" name="respuestas[{{ $pregunta->id }}]"
                            class="w-full border border-gray-300 rounded px-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="Escribe tu respuesta aquí">
                    @elseif ($pregunta->tipo == 'opcion')
                        <div class="space-y-2">
                            @foreach ($pregunta->opciones as $opcion)
                                <label class="flex items-center space-x-2 text-gray-700">
                                <input type="radio" name="respuestas[{{ $pregunta->id }}]"
                                    value="{{ $opcion->id }}"
                                    class="text-blue-600 focus:ring-blue-500 opcion-radio"
                                    data-es-otro="{{ strtolower($opcion->texto) === 'otro' ? 'true' : 'false' }}">
                                <span>{{ $opcion->texto }}</span>
                            </label>
                            @endforeach
                            <!-- Input dinámico para "Otro" -->
                            <input type="text" name="respuestas_otro[{{ $pregunta->id }}]"
                                class="mt-2 border px-2 py-1 rounded w-full hidden campo-otro"
                                placeholder="Especifique otro...">
                        </div>
                    @elseif ($pregunta->tipo == 'imagen')
                            
                            <label class="block text-gray-700 text-sm font-bold mb-2">Adjuntar imagen</label>
                            <input type="file" name="file" id="" accept="image/*">
                            
                            @error('file')
                                <p class="text-red-600 text-sm mt-1 font-semibold">Error: {{ $message }}</p>
                            @enderror
                    @elseif ($pregunta->tipo == 'seleccion_multiple')
                        <div class="space-y-2">
                           @foreach ($pregunta->opciones as $opcion)
                            <label class="flex items-center space-x-2 text-gray-700">
                                <input type="checkbox" name="respuestas[{{ $pregunta->id }}][]"
                                    value="{{ $opcion->id }}"
                                    class="text-blue-600 focus:ring-blue-500 opcion-checkbox"
                                    data-es-otro="{{ strtolower($opcion->texto) === 'otro' ? 'true' : 'false' }}">
                                <span>{{ $opcion->texto }}</span>
                            </label>
                            @endforeach
                            <!-- Input dinámico para "Otro" -->
                            <input type="text" name="respuestas_otro[{{ $pregunta->id }}]"
                                class="mt-2 border px-2 py-1 rounded w-full hidden campo-otro"
                                placeholder="Especifique otro...">
                            </div>
                    @elseif ($pregunta->tipo == 'fecha')
                        <input type="date" name="respuestas[{{ $pregunta->id }}]"
                            class="w-full border border-gray-300 rounded px-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">

                    @elseif ($pregunta->tipo == 'datos_personales')
                        @php
                       
                            $texto = strtolower(trim($pregunta->texto));
                            $valor = '';

                            switch ($texto) {
                                case 'nombre y apellido':
                                    $valor = auth()->user()->name ?? '';
                                    break;
                                case 'correo':
                                    $valor = auth()->user()->email ?? '';
                                    break;
                                case 'cargo':
                                    $valor = auth()->user()->charge ?? '';
                                    break;
                                case 'ods':
                                    $valor = auth()->user()->ods ?? '';
                                    break;
                                case 'ubicación':
                                    $valor = auth()->user()->location ?? '';
                                    break;
                            }
                        @endphp

                <input type="text" name="respuestas[{{ $pregunta->id }}]" value="{{ $valor }}"
                    class="w-full border border-gray-300 rounded px-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"
                    readonly onfocus="this.removeAttribute('readonly')"
                    placeholder="Completa aquí tu dato personal">

                    @endif
                </div>
            @endforeach

            <div class="text-center pt-4">
                <button type="submit"
                    class="bg-red-700 hover:bg-red-800 text-white font-semibold px-6 py-2 rounded transition duration-200">Enviar
                    Respuestas</button>
            </div>
        </form>
    </div>

</body>

<script>
document.addEventListener('DOMContentLoaded', function () {
    // Radios (tipo opción)
    document.querySelectorAll('.opcion-radio').forEach(function (radio) {
        radio.addEventListener('change', function () {
            const parent = radio.closest('div');
            const inputOtro = parent.querySelector('.campo-otro');
            if (radio.dataset.esOtro === 'true' && radio.checked) {
                inputOtro.classList.remove('hidden');
            } else {
                inputOtro.classList.add('hidden');
            }
        });
    });

    // Checkboxes (selección múltiple)
    document.querySelectorAll('.opcion-checkbox').forEach(function (checkbox) {
        checkbox.addEventListener('change', function () {
            const parent = checkbox.closest('div');
            const inputOtro = parent.querySelector('.campo-otro');
            const hayAlgunoSeleccionado = [...parent.querySelectorAll('.opcion-checkbox')]
                .some(cb => cb.checked && cb.dataset.esOtro === 'true');
            if (hayAlgunoSeleccionado) {
                inputOtro.classList.remove('hidden');
            } else {
                inputOtro.classList.add('hidden');
            }
        });
    });
});
</script>

</html>
