<nav class="bg-red-900">
    <div class="mx-auto max-w-7xl px-2 sm:px-6 lg:px-8">
        <div class="relative flex h-16 items-center justify-between">
            <div class="absolute inset-y-0 left-0 flex items-center sm:hidden">
                <!-- Mobile menu button-->
                <button type="button" id="mobile-menu-button"
                    class="relative inline-flex items-center justify-center rounded-md p-2 text-gray-400  hover:text-white focus:outline-none focus:ring-2 focus:ring-inset focus:ring-white"
                    aria-controls="mobile-menu" aria-expanded="false">
                    <span class="absolute -inset-0.5"></span>
                    <span class="sr-only">Open main menu</span>
                    <svg class="block h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" aria-hidden="true">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" />
                    </svg>
                    <svg class="hidden h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" aria-hidden="true">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <div class="flex flex-1 items-center justify-center sm:items-stretch sm:justify-start">
                <div class="flex flex-shrink-0 items-center">
                    <img class="h-8 w-auto" src="{{ asset('images/logo.png') }}" alt="Ingicat">
                </div>
                <div class="hidden sm:ml-6 sm:block">
                    <div class="flex space-x-4">
                        <a href="{{ route('inicio') }}"
                            class="rounded-md hover:bg-red-700 px-3 py-2 text-sm text-gray-300 font-medium hover:text-white"
                            aria-current="page">Inicio</a>
                        <a href="{{ route('producto') }}"
                            class="rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-red-700 hover:text-white">Reporte
                        </a>
                        {{-- <a href="{{ route('lista') }}"
                            class="rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-red-700 hover:text-white">Historial</a> --}}

                        <div class="relative group">
                            <button id="historial-button"
                                class="w-full flex justify-between items-center rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                                Historial
                                <i class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                            </button>
                            <div id="sub-menu2"
                                class="hidden absolute right-0 mt-2 w-48 bg-red-900 rounded-md shadow-lg z-20">
                                <a href="{{ route('history') }}"
                                    class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Tiempo</a>
                                <a href="{{ route('lista') }}"
                                    class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Producto</a>
                            </div>
                        </div>

                        <div class="relative group">
                            <button id="revision-button"
                                class="w-full flex justify-between items-center rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                                Revisiones
                                <i class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                            </button>
                            <div id="sub-menu3"
                                class="hidden absolute right-0 mt-2 w-48 bg-red-900 rounded-md shadow-lg z-20">
                                <a href="{{ route('enviar') }}"
                                    class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Enviar</a>
                                <a href="{{ route('recepcion') }}"
                                    class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Recepción</a>
                            </div>
                        </div>
                        <a href="{{route('hse.ver')}}" class="rounded-md hover:bg-red-700 px-3 py-2 text-sm text-gray-300 font-medium hover:text-white"
                                    aria-current="page"> Encuestas </a>

                        {{--  --}}

                        @if (Auth::check())
                            @if (Auth::user()->rol === 'Administrador')
                                <a href="{{ route('usuario') }}"
                                    class="rounded-md hover:bg-red-700 px-3 py-2 text-sm text-gray-300 font-medium hover:text-white"
                                    aria-current="page">Usuarios</a>
                                <div class="relative group">
                                    <button id="hse-button" class="w-full flex justify-between items-center rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                                        HSE
                                        <i class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                                    </button>
                                    <div id="sub-menu4"
                                        class="hidden absolute right-0 mt-2 w-48 bg-red-900 rounded-md shadow-lg z-20">
                                        <a href="{{ route('hse.crear') }}"
                                            class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Crear encuesta</a>
                                        <a href="{{ route('admin.encuesta') }}"
                                            class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Administrar encuesta</a>
                                    </div>
                                </div>
                                <div class="relative group">
                                    <button id="registros-button"
                                        class="w-full flex justify-between items-center rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                                        Registros
                                        <i class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                                    </button>
                                    <div id="sub-menu"
                                        class="hidden absolute right-0 mt-2 w-48 bg-red-900 rounded-md shadow-lg z-20">
                                        <a href="{{ route('asignacion') }}"
                                            class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Asignar
                                            Profesional</a>
                                        <a href="{{ route('sig.index') }}"
                                            class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Registrar
                                            SIG</a>
                                        <a href="{{ route('registros') }}"
                                            class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Aprobadores</a>
                                        <a href="{{ route('descarga.index') }}"
                                            class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Descargar
                                            productos</a>
                                        <a href="{{ route('revision') }}"
                                            class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Descargar
                                            revisiones</a>
                                        <a href="{{ route('agregar.index') }}"
                                            class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Agregar
                                            Producto</a>
                                    </div>
                                    
                                </div>
                            @else
                                @if (Auth::user()->rol === 'Planeador')
                                    <div class="relative group">
                                        <button id="registros-button"
                                            class="w-full flex justify-between items-center rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                                            Registros
                                            <i
                                                class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                                        </button>
                                        <div id="sub-menu"
                                            class="hidden absolute right-0 mt-2 w-48 bg-red-900 rounded-md shadow-lg z-20">
                                            <a href="{{ route('asignacion') }}"
                                                class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Asignar
                                                Profesional</a>
                                            <a href="{{ route('sig.index') }}"
                                                class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Registrar
                                                SIG</a>
                                        </div>
                                    </div>
                                @endif

                            @endif
                                @if (Auth::user()->rol === 'Hse')
                                <div class="relative group">
                                    <button id="hse-button" class="w-full flex justify-between items-center rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                                        HSE
                                        <i class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                                    </button>
                                    <div id="sub-menu4"
                                        class="hidden absolute right-0 mt-2 w-48 bg-red-900 rounded-md shadow-lg z-20">
                                        <a href="{{ route('hse.crear') }}"
                                            class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Crear encuesta</a>
                                        <a href="{{ route('admin.encuesta') }}"
                                            class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Administrar encuesta</a>
                                    </div>
                                </div>
                                @endif
                        @endif
                    </div>
                </div>
            </div>
            <div class="absolute inset-y-0 right-0 flex items-center pr-2 sm:static sm:inset-auto sm:ml-6 sm:pr-0">


                <!-- Profile dropdown -->
                <div class="relative ml-3">

                    <button type="button" id="profile-menu-button"
                        class="relative flex rounded-full red-900 text-sm focus:outline-none {{-- focus:ring-2 --}} {{-- focus:ring-white focus:ring-offset-2 focus:ring-offset-gray-800 --}}"
                        id="user-menu-button" aria-expanded="false" aria-haspopup="true">
                        <span class="absolute -inset-1.5"></span>
                        <span class="sr-only">Open user menu</span>
                        <div class="text-3xl text-white">
                            <i class="fa-regular fa-user" id="user-icon"></i>
                            {{-- <img class="h-8 w-8 rounded-full" src="" alt=""> --}}
                        </div>
                    </button>


                    <div id="profile-menu"
                        class="absolute right-0 z-10 mt-2 w-48 origin-top-right rounded-md bg-white py-1 shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                        role="menu" aria-orientation="vertical" aria-labelledby="user-menu-button"
                        tabindex="-1">
                        @if (Auth::check())
                            <strong
                                class="block px-4 py-2 text-xs text-gray-700 text-center hover:bg-red-700 hover:text-white"><a
                                    href="{{ route('configurar') }}">{{ Auth::user()->name }}</a></strong>
                        @endif
                        <!-- Active: "bg-gray-100", Not Active: "" -->
                        {{-- <a href="{{ route('cambio') }}"
                            class="block px-4 py-2 text-sm text-gray-700 hover:bg-red-700 hover:text-white text-center "
                            id="user-menu-item-1">Cambiar Contraseña</a> --}}

                        <form action="{{ url('logout') }}" method="POST">
                            @csrf
                            <button
                                class="block px-4 py-2 text-sm text-gray-700 hover:bg-red-700 hover:text-white w-full"
                                type="submit" id="user-menu-item-2"> Salir </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile menu, show/hide based on menu state. -->
    <div class="sm:hidden" id="mobile-menu">
        <div class="space-y-1 px-2 pb-3 pt-2">
            <!-- Current: "bg-gray-900 text-white", Default: "text-gray-300 hover:bg-gray-700 hover:text-white" -->
            <a href="{{ route('inicio') }}" class="block rounded-md px-3 py-2 text-base font-medium text-white"
                aria-current="page">Inicio</a>
            <a href="{{ route('producto') }}"
                class="block rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-red-700 hover:text-white">Reporte
            </a>
            {{-- <a href="{{ route('lista') }}"
                class="rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-red-700 hover:text-white">Historial</a> --}}
            <div class="relative group">
                <button id="historials-button"
                    class="w-full flex justify-between items-center rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                    Historial
                    <i class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                </button>
                <div id="subb-menu2" class="hidden mt-2 space-y-1">
                    <a href="{{ route('history') }}"
                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Tiempo</a>
                    <a href="{{ route('lista') }}"
                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Producto</a>
                </div>
            </div>

            <div class="relative group">
                <button id="revisiones-button"
                    class="w-full flex justify-between items-center rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                    Revisiones
                    <i class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                </button>
                <div id="subb-menu3" class="hidden mt-2 space-y-1">
                    <a href="{{ route('enviar') }}"
                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Enviar</a>
                    <a href="{{ route('recepcion') }}"
                        class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Recepción</a>
                </div>
            </div>
            <a href="{{route('hse.ver')}}" class="block rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-red-700 hover:text-white"> Encuestas </a>
            @if (Auth::check())
                @if (Auth::user()->rol === 'Administrador')
                    <a href="{{ route('usuario') }}"
                        class="block rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-red-700 hover:text-white">Usuarios</a>
                    <div class="relative group">
                        <button id="registross-button"
                            class="w-full flex justify-between items-center rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                            Registros
                            <i class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                        </button>
                        <div id="subb-menu" class="hidden mt-2 space-y-1">
                            <a href="{{ route('asignacion') }}"
                                class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Asignar
                                Profesional</a>
                            <a href="{{ route('sig.index') }}"
                                class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Registrar
                                SIG</a>
                            <a href="{{ route('registros') }}"
                                class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Aprobadores</a>
                            <a href="{{ route('descarga.index') }}"
                                class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Descargar
                                productos</a>
                            <a href="{{ route('revision') }}"
                                class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Descargar
                                revisiones</a>
                            <a href="{{ route('agregar.index') }}"
                                class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Agregar
                                Producto</a>
                        </div>
                    </div>
                    <div class="relative group">
                        <button id="registrosss-button"
                            class="w-full flex justify-between items-center rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                            HSE
                            <i class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                        </button>
                        <div id="subbb-menu" class="hidden mt-2 space-y-1">
                            <a href="{{ route('asignacion') }}"
                                class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Crear encuesta</a>
                                <a href="{{ route('sig.index') }}"class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Administrar encuestas</a>
                        </div>
            </div>
                @else
                    @if (Auth::user()->rol === 'Planeador')
                        <div class="relative group">
                            <button id="registross-button"
                                class="w-full flex justify-between items-center rounded-md px-3 py-2 text-base font-medium text-gray-300 hover:bg-red-700 hover:text-white">
                                Registros
                                <i class="fa-solid fa-angle-down ml-2 text-gray-400 group-hover:text-white"></i>
                            </button>
                            <div id="subb-menu" class="hidden mt-2 space-y-1">
                                <a href="{{ route('asignacion') }}"
                                    class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Asignar
                                    Profesional</a>
                                <a href="{{ route('sig.index') }}"
                                    class="block px-4 py-2 text-sm text-gray-300 hover:bg-red-700 hover:text-white">Registrar
                                    SIG</a>
                            </div>
                        </div>
                    @endif
                @endif
                {{-- colocar autentication de rol de hse --}}
            @endif
        </div>
    </div>
</nav>

<!-- Include JavaScript for profile dropdown -->
<script src="{{ asset('js/despli.js') }}"></script>
<script>
    const button = document.getElementById('profile-menu-button');
    const icon = document.getElementById('user-icon');

    function toggleFade() {
        icon.classList.toggle('fa-bounce');
    }

    button.addEventListener('click', toggleFade);
    button.addEventListener('touchend', toggleFade);

    button.addEventListener('mouseenter', () => {
        icon.classList.add('fa-bounce');
    });

    button.addEventListener('mouseleave', () => {
        icon.classList.remove('fa-bounce');
    });

    // Función para manejar el toggle del submenú
    function toggleSubMenu(buttonId, menuId) {
        const button = document.getElementById(buttonId);
        const menu = document.getElementById(menuId);

        // Verificar si el botón y el menú existen
        if (button && menu) {
            button.addEventListener('click', () => {
                menu.classList.toggle('hidden');
            });

            document.addEventListener('click', (e) => {
                if (!button.contains(e.target) && !menu.contains(e.target)) {
                    menu.classList.add('hidden');
                }
            });
        }
    }

    document.addEventListener('DOMContentLoaded', () => {
        // Inicializar los submenús
        toggleSubMenu('historial-button', 'sub-menu2');
        toggleSubMenu('registros-button', 'sub-menu');
        toggleSubMenu('revision-button', 'sub-menu3');
        //toggleSubMenu('encuesta-button', 'encuesta-menu');
        //toggleSubMenu('usuarios-button', 'usuarios-menu');
        toggleSubMenu('hse-button', 'sub-menu4');

        // Para los botones del móvil
        toggleSubMenu('historials-button', 'subb-menu2');
        toggleSubMenu('registross-button', 'subb-menu');
        toggleSubMenu('registrosss-button', 'subbb-menu');

        toggleSubMenu('revisiones-button', 'subb-menu3');
        //toggleSubMenu('encuestas-button', 'encuestas-menu');
        //toggleSubMenu('hse-button', 'sub-menu4');
    });

    // button.addEventListener('click', () => {
    //     menu.classList.toggle('hidden');
    // });

    // document.addEventListener('click', (e) => {
    //     if (!button.contains(e.target) && !menu.contains(e.target)) {
    //         menu.classList.add('hidden');
    //     }
    // });
    // }

    // Inicializar los submenús
    // toggleSubMenu('historial-button', 'sub-menu2');
    // toggleSubMenu('registros-button', 'sub-menu');

    // // Para los botones del móvil
    // toggleSubMenu('historials-button', 'subb-menu2');
    // toggleSubMenu('registross-button', 'subb-menu');
</script>
