<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid black;
            font-size: 8;
        }

        th,
        td {
            border: 3px solid black;
            text-align: center;
            padding: 5px;
            border: 2px solid black;
        }

        th {
            background-color: #f2f2f2;
        }

        .header-table,
        .header-table td {
            border: none;
        }
    </style>

<body>
    <table class="header-table">
        <thead>
            <tr>
                <th style="border: 1px solid black; background:#e7a5a5;">ID
                </th>
                <th style="border: 1px solid black; background:#e7a5a5;">Remitene
                </th>
                <th style="border: 1px solid black; background:#e7a5a5;">Destinatario
                </th>
                <th style="border: 1px solid black; background:#e7a5a5;">Producto
                </th>
                <th style="border: 1px solid black; background:#e7a5a5;">Fecha envio
                </th>
                <th style="border: 1px solid black; background:#e7a5a5;">Fecha respuesta
                </th>
                <th style="border: 1px solid black; background:#e7a5a5;">N° errores
                </th>
                <th style="border: 1px solid black; background:#e7a5a5;">Observaciones
                </th>
                <th style="border: 1px solid black; background:#e7a5a5;">Link
                </th>
            </tr>
        </thead>

        <tbody>
            @php
                use Carbon\Carbon;
                Carbon::setLocale('es');
                $fechaSeleccionada2 = Carbon::parse($fechaSeleccionada2);
                $fechaSeleccionada3 = Carbon::parse($fechaSeleccionada3);

                $contador = 1;
            @endphp
            @foreach ($revision as $revi)
                @php
                    $fechaRevision = Carbon::parse($revi->date); // Asegúrate de que $report->date es la fecha del report
                    $estado = $revi->fecha_respuesta;
                    $enlace = $revi->link;
                    $observacionesConSaltos = $revi->observaciones ? nl2br(e($revi->observaciones)) : 'No disponible';
                @endphp
                @if (/* $fechaRevision->between($fechaSeleccionada2, $fechaSeleccionada3) && */ $estado !== null && $enlace !== null)
                    <tr>
                        <td>{{ $contador }}</td>
                        <td>{{ $revi->remitenteUser->name ?? 'Desconocido' }}</td>
                        <td>{{ $revi->destinatarioUser->name ?? 'Desconocido' }}</td>
                        <td>{{ $revi->titulo }}</td>
                        <td>{{ $revi->fecha_envio }}</td>
                        <td>{{ $revi->fecha_respuesta }}</td>
                        <td>{{ $revi->n_errores }}</td>
                        <td>{!! $observacionesConSaltos !!}</td>
                        <td>{{ $revi->link }}</td>
                    </tr>

                    @php
                        $contador++;
                    @endphp
                @endif
            @endforeach
        </tbody>

    </table>
</body>

</html>
