<div class="overflow-x-auto">
    <table class="w-full text-sm text-left text-gray-500 ">
        <thead class="text-xs text-gray-700 uppercase bg-gray-50 ">
            <tr>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">
                    Nombre</th>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">Cargo
                </th>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">
                    Rol</th>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">
                    Estado</th>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">
                    Accion</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $user)
                <tr class="border-b hover:bg-gray-100">
                    <td class="flex items-center p-4 mr-12 space-x-6 whitespace-nowrap">
                        {{-- <img class="w-10 h-10 rounded-full" src="{{ asset('images/user.png') }}" alt="user"> --}}
                        <div class="text-sm font-normal text-gray-500 ">
                            <div class="text-base font-semibold text-gray-900">
                                {{ $user->name }}</div>
                            <div class="text-sm font-normal text-gray-500 ">
                                {{ $user->email }}</div>
                        </div>
                    </td>

                    <td class="p-4 text-base font-medium text-gray-900 whitespace-nowrap">
                        {{ $user->charge }}</td>
                    <td class="p-4 text-base font-medium text-gray-900 whitespace-nowrap">
                        {{ $user->rol }}</td>
                    <td class="p-4 text-base font-normal text-gray-900 whitespace-nowrap">
                        <div class="flex items-center">
                            <div
                                class="h-2.5 w-2.5 rounded-full mr-2 {{ $user->state == 'Activo' ? 'bg-green-500' : 'bg-red-500' }}">
                            </div>
                            {{ $user->state == 'Activo' ? 'Activo' : 'Inactivo' }}
                        </div>
                    </td>


                    <td class="p-4 space-x-2 whitespace-nowrap">
                        <button type="button"
                            class="bg-blue-600 edit-btn inline-flex items-center px-3 py-2 text-sm font-medium text-center text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300"
                            data-id="{{ $user->id }}">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M17.414 2.586a2 2 0 00-2.828 0L7 10.172V13h2.828l7.586-7.586a2 2 0 000-2.828z">
                                </path>
                                <path fill-rule="evenodd"
                                    d="M2 6a2 2 0 012-2h4a1 1 0 010 2H4v10h10v-4a1 1 0 112 0v4a2 2 0 01-2 2H4a2 2 0 01-2-2V6z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            Editar
                        </button>
                        <button type="button"
                            onclick="toggleUserStatus({{ $user->id }}, '{{ $user->state == 'Activo' ? 'Inactivo' : 'Activo' }}')"
                            class="inline-flex items-center px-3 py-2 text-sm font-medium text-center text-white {{ $user->state == 'Activo' ? 'bg-yellow-600 rounded-lg hover:bg-yellow-800 focus:ring-4 focus:ring-yellow-300' : 'bg-green-600 rounded-lg hover:bg-green-800 focus:ring-4 focus:ring-green-300' }}">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 22"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12ZM12 8.25a.75.75 0 0 1 .75.75v3.75a.75.75 0 0 1-1.5 0V9a.75.75 0 0 1 .75-.75Zm0 8.25a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            {{ $user->state == 'Activo' ? 'inhabilitar' : 'habilitar' }}
                        </button>
                    </td>

                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<div class="pagination">
    {!! $users->links() !!}
</div>
