<div class="relative overflow-x-auto shadow-md sm:rounded-lg">
    <table class="w-full text-sm text-left rtl:text-right text-gray-500">
        <thead class="text-xs text-gray-700 uppercase bg-gray-50">
            <tr>
                <th scope="col" class="px-6 py-3">
                    Titulo
                </th>
                <th scope="col" class="px-6 py-3">
                    Remitente
                </th>
                <th scope="col" class="px-6 py-3">
                    Destinatario
                </th>
                <th scope="col" class="px-6 py-3">
                    Fecha Envio
                </th>
                <th scope="col" class="px-6 py-3">
                    Link
                </th>
                <th scope="col" class="px-6 py-3">
                    Responder
                </th>
            </tr>
        </thead>
        <tbody>
            @foreach ($recepciones as $recepcion)
                <tr class="bg-white border-b hover:bg-gray-50">
                    <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                        {{ $recepcion->titulo }}
                    </th>
                    <td class="px-6 py-4">
                        {{ $recepcion->remitenteUser->name ?? 'Desconocido' }}
                    </td>
                    <td class="px-6 py-4">
                        {{-- {{ $recepcion->destinatario }} --}}
                        {{ $recepcion->destinatarioUser->name ?? 'Desconocido' }}
                    </td>
                    <td class="px-6 py-4">
                        {{ $recepcion->fecha_envio }}
                    </td>
                    <td class="px-6 py-4">
                        <a href="{{ $recepcion->link }}" target="_blank"
                            class="font-medium text-blue-600 hover:underline">Enlace</a>
                    </td>
                    <td class="px-6 py-4">
                        <button class="recepcion-btn font-medium text-blue-600 hover:underline"
                            data-id="{{ $recepcion->id }}"><i class="fa-solid fa-pen-to-square"
                                style="font-size: 20px;"></i></button>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
    <div class="pagination">
        {!! $recepciones->links() !!}
    </div>
</div>
