<div class="relative overflow-x-auto shadow-md sm:rounded-lg">
    <table class="w-full text-sm text-left rtl:text-right text-gray-500">
        <thead class="text-xs text-gray-700 uppercase bg-gray-50">
            <tr>
                <th scope="col" class="px-6 py-3">
                    Titulo
                </th>
                <th scope="col" class="px-6 py-3">
                    Destinatario
                </th>
                <th scope="col" class="px-6 py-3">
                    Fecha Envio
                </th>
                <th scope="col" class="px-6 py-3">
                    N° Errores
                </th>
                <th scope="col" class="px-6 py-3">
                    Detalles
                </th>
            </tr>
        </thead>
        <tbody>
            @foreach ($miLista as $lista)
                <tr class="bg-white border-b hover:bg-gray-50">
                    <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                        {{ $lista->titulo }}
                    </th>
                    <td class="px-6 py-4">
                        {{ $lista->destinatarioUser->name ?? 'Desconocido' }}
                    </td>
                    <td class="px-6 py-4">
                        {{ $lista->fecha_envio }}
                    </td>
                    <td class="px-6 py-4">
                        {{ $lista->n_errores }}
                    </td>
                    <td class="px-6 py-4">
                        @if (!$lista->fecha_respuesta)
                            <button class="font-medium text-blue-600" disabled>
                                Pendiente..
                            </button>
                        @else
                            <!-- Si quieres ocultar el botón, deja vacío o comenta el else -->
                            <button class="revision-btn font-medium text-blue-600"
                                data-fecha-respuesta="{{ $lista->fecha_respuesta }}" data-link="{{ $lista->link }}"
                                data-observaciones="{{ $lista->observaciones }}"><i class="fa-solid fa-magnifying-glass"
                                    style="font-size: 20px;">
                                </i></button>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
    <div class="pagination">
        {!! $miLista->links() !!}
    </div>
</div>
