<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <title>Recepción - INGICAT</title>
</head>

<body>
    @include('layout.header')

    <div class="container w-11/12 mx-auto py-12">
        <h2 class="text-center text-base font-semibold leading-7 text-gray-900">RECEPCIÓN</h2>
        <br>
        <div class="mt-8 overflow-x-auto">
            <div id="TablaRecepcion">
                @include('partials.tableRecepcion')
            </div>
        </div>
    </div>

    {{-- modal de respuesta de revision --}}
    <div id="respuestaModal" class="fixed inset-0 hidden z-50 overflow-y-auto">
        <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
        <div class="flex items-center justify-center min-h-screen">
            <div class="relative w-full max-w-lg rounded-lg shadow bg-white">
                <div class="flex items-start justify-between p-4 border-b rounded-t">
                    <button type="button"
                        class="text-black bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center"
                        data-modal-hide="respuestaModal">
                        <i class="fa-solid fa-x"></i>
                    </button>
                </div>
                <div class="p-6 space-y-6">
                    <form id="recepcionForm" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="">
                            <div>
                                <label for="errores" class="block text-sm font-medium leading-6 text-gray-900">N°
                                    Errores
                                    Electrónico</label>
                                <input type="number" id="errores" name="errores"
                                    class="block w-24 rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6"
                                    required>
                            </div>

                            <div>
                                <label for="observaciones"
                                    class="block text-sm font-medium leading-6 text-gray-900">Oservaciones</label>
                                <textarea name="observaciones" id="observaciones" cols="30" rows="10"
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6"></textarea>
                            </div>

                        </div>
                        <div class="mt-4">
                            <button type="submit"
                                class="w-full bg-red-900 text-white py-2 rounded-md shadow-sm hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">Actualizar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="{{ asset('js/recepcion.js') }}"></script>
</body>

</html>
