<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <title>Registros</title>
</head>

<body>
    @include('layout.header')

    <div class="container w-11/12 mx-auto py-12">

        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-3 sm:grid-cols-2">

            <div>
                <form id="aprobado" action="{{ route('aprobador.store') }}" method="post">
                    @csrf
                    <h2 class="text-center font-semibold leading-7 text-gray-900">REGISTRAR APROBADOR</h2>
                    <label for="identification" class="block text-sm font-medium leading-6 text-gray-900">Identificación
                        <strong class=" text-red-600">*</strong></label>
                    <div class="mt-2">
                        <input type="number" name="identification" id="identification" autocomplete="off" required
                            placeholder="0000000000"
                            class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                    </div>

                    <label for="name" class="block text-sm font-medium leading-6 text-gray-900">Nombre
                        <strong class=" text-red-600">*</strong></label>
                    <div class="mt-2">
                        <input type="text" name="name" id="name" autocomplete="off" required
                            placeholder="XXXXXX XXXXXX XXXXXX"
                            class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                    </div>

                    <label for="charge" class="block text-sm font-medium leading-6 text-gray-900">Cargo
                        <strong class=" text-red-600">*</strong></label>
                    <div class="mt-2">
                        <select id="charge" name="charge" autocomplete="charge" required
                            class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 sm:text-sm sm:leading-6">
                            <option value="">Seleccionar</option>
                            @foreach ($cargos as $cargo)
                                <option value="{{ $cargo->charge }}">{{ $cargo->charge }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mt-6 flex items-center justify-end ">
                        <button type="submit"
                            class="rounded-md bg-red-800 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">
                            Registrar</button>
                    </div>
                </form>
            </div>

            <div>
                <div class="mt-8 overflow-x-auto">
                    <h3 class="text-xl font-semibold mb-4">LISTA APROBADOS</h3>
                    <div id="divTable">
                        @include('partials.tablaAprbador')
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="{{ asset('js/aprobador.js') }}"></script>
</body>

</html>
