@php
    $odsUsuario = Auth::user()->ods ?? 'No asignado';
@endphp
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <title>Reporte</title>
</head>

<body>
    @include('layout.header')
    <div class="container w-11/12 mx-auto py-12">
        <form id="registro-form" action="{{ route('producto.store') }}" method="POST">
            @csrf
            <div class="space-y-12">
                <div class="border-b border-gray-900/10 pb-12">
                    <h2 class="text-center text-base font-semibold leading-7 text-gray-900">REGISTRAR TAREA</h2>

                    <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-3 md:grid-cols-3">

                        <div>
                            <label for="sector" class="block text-sm font-medium leading-6 text-gray-900">Perfil
                                <strong class=" text-red-600">*</strong></label>
                            <div class="mt-2">
                                <select id="sector" name="sector" autocomplete="sector" required
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300  sm:text-sm sm:leading-6">
                                    <option value="">Seleccionar</option>
                                    @foreach ($sectores as $sector)
                                        <option value="{{ $sector->sector }}"
                                            {{ $sector->sector === $usuario->charge ? 'selected' : '' }}>
                                            {{-- <option value="{{ $sector->sector }}"> --}}
                                            {{ $sector->sector }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div>
                            <label for="producto" class="block text-sm font-medium leading-6 text-gray-900">Producto
                                <strong class=" text-red-600">*</strong></label>
                            <div class="mt-2">
                                <select id="producto" name="producto" autocomplete="producto" required
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 sm:text-sm sm:leading-6">
                                    <option value="">Seleccionar</option>
                                    @foreach ($productos as $producto)
                                        <option value="{{ $producto->product }}">{{ $producto->product }}</option>
                                    @endforeach
                                    <option value="Otro">Otro...</option>
                                </select>
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-medium leading-6 text-gray-900">Categoría <strong
                                    class=" text-red-600">*</strong></label>
                            <div class="mt-2">
                                <p><strong id="category"></strong></p>
                                <input type="hidden" name="categoria" id="categoria" required>
                            </div>
                        </div>

                        <div>
                            <label for="fecha" class="block text-sm font-medium leading-6 text-gray-900">Fecha
                                <strong class=" text-red-600">*</strong></label>
                            <div class="mt-2">
                                <input type="date" name="fecha" id="fecha" autocomplete="off" required
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                            </div>
                        </div>

                        <div>
                            <label for="fn" class="block text-sm font-medium leading-6 text-gray-900">Fn <strong
                                    class=" text-red-600">*</strong></label>
                            <div class="mt-2">
                                <select id="fn" name="fn" autocomplete="fn" required
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300  sm:text-sm sm:leading-6">
                                    <option value="">Seleccionar</option>
                                    <option value="No Aplica">No Aplica</option>
                                    <option value="Directriz">Directriz</option>
                                    @foreach ($fnasignados as $fnasignado)
                                        <option value="{{ $fnasignado->fn }}">{{ $fnasignado->fn }}</option>
                                    @endforeach
                                    <option value="Invasiones">Invasiones</option>
                                    <option value="Otro">Otro...</option>
                                </select>
                            </div>
                        </div>

                        <div>
                            <label for="codigo" class="block text-sm font-medium leading-6 text-gray-900">Código
                                SIG <strong class=" text-red-600">*</strong></label>
                            <div class="mt-2">
                                <select id="codigo" name="codigo" autocomplete="codigo" required
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300  sm:text-sm sm:leading-6">
                                    <option value="">Seleccionar</option>

                                </select>
                            </div>
                        </div>

                        <div>
                            <label for="servicio" class="block text-sm font-medium leading-6 text-gray-900">Servicio
                                <strong class=" text-red-600">*</strong></label>
                            <div class="mt-2">
                                <select id="servicio" name="servicio" autocomplete="servicio" required
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300  sm:text-sm sm:leading-6">
                                    <option value="">Seleccionar</option>

                                </select>
                            </div>
                        </div>

                        <div>
                            <label for="ubicacion" class="block text-sm font-medium leading-6 text-gray-900">Ubicación
                                <strong class=" text-red-600">*</strong></label>

                            @php
                                $ubicacionUsuario = Auth::user()->location ?? '';
                                $activoUsuario = Auth::user()->activo ?? '';
                            @endphp
                            <div class="mt-2">
                                <select id="ubicacion" name="ubicacion" autocomplete="ubicacion" required
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300  sm:text-sm sm:leading-6">
                                    <option value="{{ $ubicacionUsuario }}">{{ strtoupper($ubicacionUsuario) }}
                                    </option>
                                    <option value="ACACIAS">ACACIÁS</option>
                                    <option value="BARRANCABERMEJA">BARRANCABERMEJA</option>
                                    <option value="BOGOTÁ">BOGOTÁ</option>
                                    <option value="VILLAVICENCIO">VILLAVICENCIO</option>
                                    <option value="YOPAL">YOPAL</option>
                                    <option value="TRABAJO EN CASA">TRABAJO EN CASA</option>
                                </select>
                            </div>
                        </div>



                        <div>
                            <label for="activo"
                                class="block text-sm font-medium leading-6 text-gray-900">Activo<strong
                                    class=" text-red-600">*</strong></label>
                            <div class="mt-2">
                                <select id="activo" name="activo"
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6"
                                    required>
                                    <option value="{{ $activoUsuario }}">{{ strtoupper($activoUsuario) }}</option>
                                    <option value="Administrativo ECP">Administrativo ECP</option>
                                    <option value="Apiay">Apiay</option>
                                    <option value="Casabe">Casabe</option>
                                    <option value="Castilla">Castilla</option>
                                    <option value="Catenare">Catenare</option>
                                    <option value="Chichimene">Chichimene</option>
                                    <option value="CPO9">CPO9</option>
                                    <option value="ELC-GRB">ELC-GRB</option>
                                    <option value="Floreña">Floreña</option>
                                    <option value="Invasiones">Invasiones</option>
                                    <option value="Lisama">Lisama</option>
                                    <option value="Llanito">Llanito</option>
                                    <option value="Nacional">Nacional</option>
                                    <option value="Provincia">Provincia</option>
                                    <option value="Transversal">Transversal</option>
                                </select>
                            </div>
                        </div>

                        <div>
                            <label for="descripcion"
                                class="block text-sm font-medium leading-6 text-gray-900">Descripción <strong
                                    class=" text-red-600">*</strong></label>
                            <div class="mt-2">
                                <textarea id="descripcion" name="descripcion" rows="2" required
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6"></textarea>
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-medium leading-6 text-gray-900">Aplica para reporte ECP
                                <strong class=" text-red-600">*</strong></label>
                            <div class="mt-2">
                                <button type="button" onclick="openModal()"
                                    class="bg-red-700 text-white px-4 py-2 rounded col-span-3"> Si</button>
                            </div>
                        </div>

                        <div tabindex="-1"
                            class="fixed inset-0 bg-gray-900 bg-opacity-50 flex justify-center items-center hidden z-50"
                            id="add-pms-modal">
                            <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
                            <div class="relative w-full max-w-4xl px-4 max-h-[95vh] overflow-y-auto">
                                <!-- Modal content -->
                                <div class="relative bg-white rounded-lg shadow">
                                    <!-- Modal header -->
                                    <div class="flex items-start justify-between p-5 border-b rounded-t">
                                        <h3 class="text-xl font-semibold">
                                            SERVICIOS - PMS
                                        </h3>
                                        <button type="button" onclick="closeModal()"
                                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center">
                                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd"
                                                    d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                                    clip-rule="evenodd"></path>
                                            </svg>
                                        </button>
                                    </div>
                                    <!-- Modal body -->

                                    <div class="p-6 space-y-6">
                                        <div class="grid grid-cols-6 gap-3">

                                            <div class="col-span-6 sm:col-span-3">
                                                <label for="aliado"
                                                    class="block mb-2 text-sm font-medium text-gray-900 ">Aliado
                                                    <strong class=" text-red-600">*</strong></label>
                                                <input type="text" id="aliado" value="Ingicat SAS"
                                                    autocomplete="off"
                                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 "
                                                    disabled>
                                            </div>
                                            <div class="col-span-6 sm:col-span-3">
                                                <label for="ods"
                                                    class="block mb-2 text-sm font-medium text-gray-900 ">Ods
                                                    <strong class=" text-red-600">*</strong></label>
                                                <input type="text" id="ods" value="{{ $odsUsuario }}"
                                                    autocomplete="off"
                                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 "
                                                    disabled>
                                            </div>
                                            <div class="col-span-6 sm:col-span-3">
                                                <label for="pms"
                                                    class="block mb-2 text-sm font-medium text-gray-900 ">ID Gestión
                                                    Predial del PMS
                                                    <strong class=" text-red-600">*</strong></label>
                                                <input type="text" name="pms" id="pms"
                                                    autocomplete="off"
                                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 "
                                                    placeholder="ej. ODS 37 INGICAT 53">
                                            </div>
                                            <div class="col-span-6 sm:col-span-3">
                                                <label for="tipo_hito"
                                                    class="block mb-2 text-sm font-medium text-gray-900 ">Tipo de Hito
                                                    Clave de Control
                                                    <strong class=" text-red-600">*</strong></label>
                                                <select id="tipo_hito" name="tipo_hito" onchange="toggleCamposHito()"
                                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 ">
                                                    <option value="">Seleccionar</option>
                                                    <option value="Hito derivado de Solicitudes de Servicio">
                                                        Hito derivado de Solicitudes de Servicio
                                                    </option>
                                                    <option
                                                        value="Hito derivado de Requerimientos No Planeados - Directriz">
                                                        Hito derivado de Requerimientos No Planeados - Directriz
                                                    </option>
                                                </select>
                                            </div>

                                            <div id="camposSolicitud" class="hidden col-span-6 sm:col-span-6">
                                                <div class="col-span-6 sm:col-span-6">
                                                    <label for="hito_clave_solicitud"
                                                        class="block mb-2 text-sm font-medium text-gray-900 "> HITO
                                                        CLAVE DE CONTROL (Solicitud de Servicio) <strong
                                                            class=" text-red-600">*</strong></label>
                                                    <select id="hito_clave_solicitud" name="hito_clave_solicitud"
                                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 ">
                                                        <option value="">Seleccionar</option>
                                                        <option value="Notificación de Trabajo">Notificación de Trabajo
                                                        </option>
                                                        <option value="Policivo">Policivo</option>
                                                        <option value="Entrega e Ingreso Efectivo al Area">Entrega e
                                                            Ingreso Efectivo al Area</option>
                                                        <option
                                                            value="Inventario de Afectaciones ó Notificación de NO Afectación">
                                                            Inventario de Afectaciones ó Notificación de NO Afectación
                                                        </option>
                                                        <option value="Radicación de Avaluo ó Concepto de Valor">
                                                            Radicación
                                                            de Avaluo ó Concepto de Valor</option>
                                                        <option value="Aviso de Obra">Aviso de Obra</option>
                                                        <option value="Informe de Identificación Predial">Informe de
                                                            Identificación Predial</option>
                                                        <option value="Estudio Titulos">Estudio Titulos</option>
                                                        <option value="COPIA / COPIO y Debida Diligencia">COPIA / COPIO
                                                            y
                                                            Debida Diligencia</option>
                                                        <option value="Acta de Daños ó Informe de Debida Diligencia">
                                                            Acta
                                                            de Daños ó Informe de Debida Diligencia</option>
                                                        <option value="Acuerdo 29">Acuerdo 29</option>
                                                        <option value="Promesa de Servidumbre o Compraventa">Promesa de
                                                            Servidumbre o Compraventa</option>
                                                        <option value="Escritura Firmada">Escritura Firmada</option>
                                                        <option value="Escritura Radicada en Pagos">Escritura Radicada
                                                            en
                                                            Pagos</option>
                                                        <option value="Acta de No Acuerdo Firmada">Acta de No Acuerdo
                                                            Firmada</option>
                                                        <option value="Depósito Judicial Radicado en Pagos">Depósito
                                                            Judicial Radicado en Pagos</option>
                                                        <option value="Radicación proceso a VIJ">Radicación proceso a
                                                            VIJ
                                                        </option>
                                                        <option value="Conceptos y Analisis">Conceptos y Analisis
                                                        </option>
                                                        <option value="Cierre Integral Gestión">Cierre Integral Gestión
                                                        </option>
                                                    </select>
                                                </div>
                                                <div class="col-span-6 sm:col-span-6">
                                                    <label for="pms"
                                                        class="block mb-2 text-sm font-medium text-gray-900 ">
                                                        Servicios
                                                        que Participan en la Elaboración del Hito<strong
                                                            class=" text-red-600">*</strong></label>
                                                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                                        <!-- Columna 1 -->
                                                        <div class="space-y-2">
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios[]"
                                                                    value="Coordinación"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Coordinación</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios[]"
                                                                    value="Gestión de Tierras"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Gestión de
                                                                    Tierras</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios[]"
                                                                    value="Análisis Legal Inmobiliario"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Análisis Legal
                                                                    Inmobiliario</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios[]"
                                                                    value="Sistemas de Información Geográfica"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Sistemas de
                                                                    Información
                                                                    Geográfica</span>
                                                            </label>
                                                        </div>

                                                        <!-- Columna 2 -->
                                                        <div class="space-y-2">
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios[]"
                                                                    value="Desarrollo y Análisis Tecnológico en Tierras"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Desarrollo y
                                                                    Análisis
                                                                    Tecnológico en Tierras</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios[]"
                                                                    value="Planeación, Seguimiento y Control Inmobiliario"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Planeación,
                                                                    Seguimiento
                                                                    y Control Inmobiliario</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios[]"
                                                                    value="Avaluos y Conceptos Valuatorios"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Avaluos y Conceptos
                                                                    Valuatorios</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios[]"
                                                                    value="Administrativo y Documental"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Administrativo y
                                                                    Documental</span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                {{-- <div class="col-span-6 sm:col-span-6">
                                                    <label for="ruta_url"
                                                        class="block mb-2 text-sm font-medium text-gray-900 ">Ruta URL
                                                        (Sharepoint) con Soporte del Entregable<strong
                                                            class=" text-red-600">*</strong></label>
                                                    <input type="url" name="ruta_url" id="ruta_url"
                                                        autocomplete="off"
                                                        class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 "
                                                        placeholder="ej. https://ecopetrol.sharepoint.com/...">
                                                </div> --}}
                                            </div>

                                            <div id="camposNoPlaneado" class="hidden col-span-6 sm:col-span-6">
                                                <div class="col-span-6 sm:col-span-6">
                                                    <label for="hito_clave_solicitud_nopplaneado"
                                                        class="block mb-2 text-sm font-medium text-gray-900 "> HITO
                                                        CLAVE DE CONTROL (Requerimiento No Planeado - Directriz) <strong
                                                            class=" text-red-600">*</strong></label>
                                                    <select id="hito_clave_solicitud_nopplaneado"
                                                        name="hito_clave_solicitud_nopplaneado"
                                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 ">
                                                        <option value="">Seleccionar</option>
                                                        <option value="Policivo">Policivo
                                                        </option>
                                                        <option value="Informes y Presentaciones">Informes y
                                                            Presentaciones</option>
                                                        <option value="Visita de Campo">Visita de Campo</option>
                                                        <option value="Comunicaciones a Terceros y OPC">Comunicaciones
                                                            a Terceros y OPC</option>
                                                        <option value="Adquisición y Suministro de Información">
                                                            Adquisición y Suministro de Información</option>
                                                        <option value="Planos y Productos Geográficos">Planos y
                                                            Productos Geográficos</option>
                                                        <option value="Analisis SIG y Jurídico">Analisis SIG y Jurídico
                                                        </option>
                                                        <option value="Atención de Invasiones">Atención de Invasiones
                                                        </option>
                                                        <option value="Participación y Actas de Reunión">Participación
                                                            y Actas de Reunión</option>
                                                        <option value="Actualización y Elaboración de BD">Actualización
                                                            y Elaboración de BD</option>
                                                    </select>
                                                </div>
                                                <div class="col-span-6 sm:col-span-6">
                                                    <label for="valoracion"
                                                        class="block mb-2 text-sm font-medium text-gray-900">Valoración
                                                        del Resultado <strong class="text-red-600">*</strong></label>
                                                    <select id="valoracion" name="valoracion"
                                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5">
                                                        <option value="">Seleccionar</option>
                                                        <option value="Impacto Alto">Impacto Alto</option>
                                                        <option value="Impacto Moderado">Impacto Moderado</option>
                                                        <option value="Impacto Bajo">Impacto Bajo</option>
                                                    </select>
                                                </div>

                                                <div class="col-span-6 sm:col-span-6">
                                                    <label for="justificacion"
                                                        class="block mb-2 text-sm font-medium text-gray-900">Justificación
                                                        del Impacto Alto<strong class="text-red-600">*</strong></label>
                                                    <textarea id="justificacion" name="justificacion" rows="3"
                                                        class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                                                        placeholder="Explique por qué el impacto es alto, medio o bajo..."></textarea>
                                                </div>

                                                <div class="col-span-6 sm:col-span-6">
                                                    <label for="funcionario"
                                                        class="block mb-2 text-sm font-medium text-gray-900">Funcionario
                                                        Solicitante del Requerimiento No Planeado <strong
                                                            class="text-red-600">*</strong></label>
                                                    {{-- <input type="text" name="funcionario" id="funcionario"
                                                        autocomplete="off"
                                                        class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                                                        placeholder="Nombre completo del solicitante"> --}}
                                                    <select id="funcionario" name="funcionario"
                                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5">
                                                        <option value="">Seleccionar</option>
                                                        <option value="Carlos Andres Teofilo Pineda Estrada">Carlos
                                                            Andres Teofilo Pineda Estrada</option>
                                                        <option value="Vladimir Alfonso Reyes Gonzalez">Vladimir
                                                            Alfonso Reyes Gonzalez</option>
                                                        <option value="Francisco Antonio Muñoz Lozada">Francisco
                                                            Antonio Muñoz Lozada</option>
                                                        <option value="Sergio Andres Viveros Arias">Sergio Andres
                                                            Viveros Arias</option>
                                                        <option value="Jorge Alberto Perez Bustos">Jorge Alberto Perez
                                                            Bustos</option>
                                                        <option value="Juan Pablo Rocha Pedraza">Juan Pablo Rocha
                                                            Pedraza</option>
                                                        <option value="Milton Cesar Burbano Cabrera">Milton Cesar
                                                            Burbano Cabrera</option>
                                                        <option value="Andrea Catalina Prieto Chaves">Andrea Catalina
                                                            Prieto Chaves</option>
                                                        <option value="John Jairo Sanabria Martinez">John Jairo
                                                            Sanabria Martinez</option>
                                                        <option value="Carlos Andres Aponte Niño">Carlos Andres Aponte
                                                            Niño</option>
                                                        <option value="Lady Johanna Guerrero Rodriguez">Lady Johanna
                                                            Guerrero Rodriguez</option>
                                                        <option value="Jhancir Armando Poveda Beltran">Jhancir Armando
                                                            Poveda Beltran</option>
                                                        <option value="Alexander Sierra Leguizamon">Alexander Sierra
                                                            Leguizamon</option>
                                                        <option value="Julio Eduardo Castro Hernandez">Julio Eduardo
                                                            Castro Hernandez</option>
                                                        <option value="Edward Leonardo Correo Bohorquez">Edward
                                                            Leonardo Correo Bohorquez</option>
                                                        <option value="Jose Luis Torres Diaz">Jose Luis Torres Diaz
                                                        </option>
                                                        <option value="Julio William Chaparro Alarcon">Julio William
                                                            Chaparro Alarcon</option>
                                                        <option value="Jairo Alberto Cruz Moreno">Jairo Alberto Cruz
                                                            Moreno</option>
                                                        <option value="Juan Manuel Valencia Escobar">Juan Manuel
                                                            Valencia Escobar</option>
                                                        <option value="Juan Carlos Hernandez Tauta">Juan Carlos
                                                            Hernandez Tauta</option>
                                                        <option value="Oliverio Antonio Moreno">Oliverio Antonio Moreno
                                                        </option>
                                                        <option value="Diego Andres Rodriguez Amaya">Diego Andres
                                                            Rodriguez Amaya</option>
                                                        <option value="Juan Guillermo Sarmiento Piñeros">Juan Guillermo
                                                            Sarmiento Piñeros</option>
                                                        <option value="Miguel Ricardo Vargas Gomez">Miguel Ricardo
                                                            Vargas Gomez</option>
                                                        <option value="Nelder Jose Solano Leon">Nelder Jose Solano Leon
                                                        </option>
                                                        <option value="Robinson Arboleda Padilla">Robinson Arboleda
                                                            Padilla</option>
                                                        <option value="Miguel Angel Rodriguez">Miguel Angel Rodriguez
                                                        </option>
                                                        <option value="Bismarck Alfonso Espitia Buitrago">Bismarck
                                                            Alfonso Espitia Buitrago</option>
                                                        <option value="Jorge Eduardo Parra Navarro">Jorge Eduardo Parra
                                                            Navarro</option>
                                                        <option value="Carlos Alberto Ortiz Vanegas">Carlos Alberto
                                                            Ortiz Vanegas</option>
                                                        <option value="Javier Armando Lopez Blanco">Javier Armando
                                                            Lopez Blanco</option>
                                                        <option value="Fanny Esperanza Lopez Silva">Fanny Esperanza
                                                            Lopez Silva</option>
                                                    </select>
                                                </div>

                                                <div class="col-span-6 sm:col-span-6">
                                                    <label for="horas"
                                                        class="block mb-2 text-sm font-medium text-gray-900">Horas
                                                        Acumuladas de Trabajo Destinadas al Cumplimiento del Hito
                                                        <strong class="text-red-600">*</strong></label>
                                                    <input type="number" name="horas" id="horas"
                                                        min="0"
                                                        class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                                                        placeholder="ej. 5">
                                                </div>

                                                <!-- Reutilizar checkboxes ya creados -->
                                                <div class="col-span-6 sm:col-span-6">
                                                    <label
                                                        class="block mb-2 text-sm font-medium text-gray-900">Servicios
                                                        que Participan en la Elaboración del Hito <strong
                                                            class="text-red-600">*</strong></label>
                                                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                                        <div class="space-y-2">
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios_no_planeado[]"
                                                                    value="Coordinación"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Coordinación</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios_no_planeado[]"
                                                                    value="Gestión de Tierras"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Gestión de
                                                                    Tierras</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios_no_planeado[]"
                                                                    value="Análisis Legal Inmobiliario"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Análisis Legal
                                                                    Inmobiliario</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios_no_planeado[]"
                                                                    value="SIG"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Sistemas de
                                                                    Información Geográfica</span>
                                                            </label>
                                                        </div>
                                                        <div class="space-y-2">
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios_no_planeado[]"
                                                                    value="Desarrollo Tecnológico"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Desarrollo y
                                                                    Análisis Tecnológico en Tierras</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios_no_planeado[]"
                                                                    value="Planeación Inmobiliaria"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Planeación,
                                                                    Seguimiento y Control Inmobiliario</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios_no_planeado[]"
                                                                    value="Avalúos"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Avaluos y Conceptos
                                                                    Valuatorios</span>
                                                            </label>
                                                            <label class="flex items-center gap-2">
                                                                <input type="checkbox" name="servicios_no_planeado[]"
                                                                    value="Administrativo"
                                                                    class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded-sm focus:ring-blue-500">
                                                                <span class="text-sm text-gray-900">Administrativo y
                                                                    Documental</span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- <div class="col-span-6 sm:col-span-6">
                                                    <label for="ruta_url_np"
                                                        class="block mb-2 text-sm font-medium text-gray-900">Ruta URL
                                                        (Sharepoint) con Soporte del Requerimiento <strong
                                                            class="text-red-600">*</strong></label>
                                                    <input type="url" name="ruta_url_np" id="ruta_url_np"
                                                        class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                                                        placeholder="https://ecopetrol.sharepoint.com/...">
                                                </div> --}}
                                            </div>

                                        </div>
                                        <button onclick="closeModal()" type="button"
                                            class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 sm:ml-3 sm:w-auto sm:text-sm">
                                            Continuar
                                        </button>
                                        <!-- Modal footer -->
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="mt-6 flex items-center justify-end gap-x-6 sm:col-span-3">
                            <button type="submit" id="submit-btn"
                                class="rounded-md bg-red-800 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">Registrar
                                tarea</button>
                        </div>

                    </div>
                </div>
            </div>
        </form>

        <!-- Modal -->
        <div id="modalOtroProducto" class="hidden fixed z-10 inset-0 overflow-y-auto">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <div
                    class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                <h3 class="text-lg leading-6 font-medium text-gray-900">
                                    Agregar Nuevo Producto y Categoría
                                </h3>
                                <div class="mt-2">
                                    <label for="nuevoProducto"
                                        class="block text-sm font-medium text-gray-700">Producto</label>
                                    <input type="text" id="nuevoProducto" name="nuevoProducto" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm sm:text-sm">
                                    <label for="nuevaCategoria"
                                        class="block text-sm font-medium text-gray-700 mt-4">Categoría</label>
                                    <select id="nuevaCategoria" name="nuevaCategoria" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm sm:text-sm">
                                        <option value="">Seleccionar</option>
                                        <option value="1. Actividad">1. Actividad</option>
                                        {{-- <option value="2. Subproducto">2. Subproducto</option>
                                        <option value="3. Producto">3. Producto</option> --}}
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="button" id="guardarProducto"
                            class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 sm:ml-3 sm:w-auto sm:text-sm">
                            Guardar
                        </button>
                        <button type="button" id="cancelarModal"
                            class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:w-auto sm:text-sm">
                            Cancelar
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <!-- Fin Modal -->

        <!-- Modal -->
        <div id="modalOtroFns" class="hidden fixed z-10 inset-0 overflow-y-auto">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <div
                    class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                <h3 class="text-lg leading-6 font-medium text-gray-900">
                                    Agregar nuevo Fn y Servicio
                                </h3>
                                <div class="mt-2">
                                    <label for="nuevoFns" class="block text-sm font-medium text-gray-700">Fn</label>
                                    <input type="text" id="nuevoFns" name="nuevoFns" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm sm:text-sm">

                                    <label for="nuevoSIG" class="block text-sm font-medium text-gray-700">Codigo
                                        SIG</label>
                                    <input type="text" id="nuevoSIG" name="nuevoSIG" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm sm:text-sm">

                                    <label for="nuevoServicio"
                                        class="block text-sm font-medium text-gray-700 mt-4">Servicio</label>
                                    <select id="nuevoServicio" name="nuevoServicio" required
                                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm sm:text-sm">
                                        <option value="">Seleccionar</option>
                                        <option value="ADMINISTRACIÓN DE DERECHOS INMOBILIARIOS">ADMINISTRACIÓN DE
                                            DERECHOS INMOBILIARIOS</option>
                                        <option value="ADQUISICIÓN DE DERECHOS INMOBILIARIOS">ADQUISICIÓN DE DERECHOS
                                            INMOBILIARIOS</option>
                                        <option value="ASESORÍA,  CONSULTORÍA  Y GESTIÓN INMOBILIARIA">ASESORÍA,
                                            CONSULTORÍA Y GESTIÓN INMOBILIARIA</option>
                                        <option value="ANÁLISIS  ESPACIAL DEL TERRITORIO">ANÁLISIS ESPACIAL DEL
                                            TERRITORIO</option>
                                        <option value="Directriz">Directriz</option>
                                        <option value="No Aplica">No Aplica</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="button" id="GuardarNuevoFn"
                            class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 sm:ml-3 sm:w-auto sm:text-sm">
                            Guardar
                        </button>
                        <button type="button" id="CancelarModalFn"
                            class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:w-auto sm:text-sm">
                            Cancelar
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <!-- Fin Modal -->

        <!--Prueba de modal de FN invasiones-->
        <div id="modalInvasiones" class="hidden fixed z-10 inset-0 overflow-y-auto">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>

                <div
                    class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                <h3 class="text-lg leading-6 font-medium text-gray-900">
                                    Invasiones
                                </h3>
                                <div class="mt-2">
                                    <label for="FNinvasion"
                                        class="block text-sm font-medium text-gray-700">Tipo</label>
                                    <select id="FNinvasion" name="FNinvasion"
                                        class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6"
                                        required>
                                        <option value="ANTICIPACION">Anticipación</option>
                                        <option value="ATENCION">Atención</option>
                                        <option value="MANEJO">Manejo</option>

                                    </select>

                                    <label for="SIGinva" class="block text-sm font-medium text-gray-700">Codigo
                                        SIG</label>
                                    <input type="text" id="SIGinva" name="SIGinva" required
                                        class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">

                                    <label for="predio"
                                        class="block text-sm font-medium text-gray-700 mt-4">Predio</label>
                                    <input id="predio" name="predio" required
                                        class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="button" id="GuardarInvasiones"
                            class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 sm:ml-3 sm:w-auto sm:text-sm">
                            Guardar
                        </button>
                        <button type="button" id="CancelInvasiones"
                            class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:w-auto sm:text-sm">
                            Cancelar
                        </button>
                    </div>
                </div>
            </div>
        </div>

        {{-- final del modal --}}





        <h2 class="text-center text-base font-semibold leading-7 text-gray-900">LISTA DE TAREAS</h2>

        <div class="mt-8 overflow-x-auto">
            <table id="miTabla" class="min-w-full bg-white">
                <thead>
                    <tr>
                        <th class="py-2 px-4 bg-gray-200 border-2 border-white">Producto</th>
                        <th class="py-2 px-4 bg-gray-200 border-2 border-white">Fecha</th>
                        <th class="py-2 px-4 bg-gray-200 border-2 border-white">FN</th>
                        <th class="py-2 px-4 bg-gray-200 border-2 border-white">Código SIG</th>

                        <th class="py-2 px-4 bg-gray-200 border-2 border-white">Descripción</th>
                        <th class="py-2 px-4 bg-gray-200 border-2 border-white">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($reportes as $reporte)
                        <tr>
                            <td class="py-2 px-4 border-2 border-gray-200">{{ $reporte->product }}</td>
                            <td class="py-2 px-4 border-2 border-gray-200">{{ $reporte->date }}</td>
                            <td class="py-2 px-4 border-2 border-gray-200">{{ $reporte->fn }}</td>
                            <td class="py-2 px-4 border-2 border-gray-200">{{ $reporte->code_sig }}</td>
                            <td class="py-2 px-4 border-2 border-gray-200">{{ $reporte->description }}</td>
                            <td class="py-2 px-4 border-2 border-gray-200">
                                <button type="button"
                                    class="actualizar-btn bg-green-500 text-white px-3 py-1 rounded-md"
                                    data-id="{{ $reporte->id }}">Editar</button>
                                <button type="button" class="novedad-btn bg-blue-500 text-white px-3 py-1 rounded-md"
                                    data-id="{{ $reporte->id }}">Novedad</button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="flex items-end justify-end min-h-3  mb-4 space-x-4 mx-auto py-12">
            <button
                class="fecha-btn rounded-md bg-red-800 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">
                Generar reporte de tiempo
            </button>


            <button
                class="reporte-btn rounded-md bg-red-800 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">
                Generar reporte producto
            </button>
        </div>

    </div>


    <div id="actualizardiv" class="fixed inset-0 hidden z-50 overflow-y-auto">
        <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
        <div class="flex items-center justify-center min-h-screen">
            <div class="relative w-full max-w-lg rounded-lg shadow bg-white">
                <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-black">
                        Editar tarea
                    </h3>
                    <button type="button"
                        class="text-black bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white"
                        data-modal-hide="actualizardiv">
                        <i class="fa-solid fa-x"></i>
                    </button>
                </div>
                <div class="p-6 space-y-6">
                    <form method="POST" id="actualizarform">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                            <div>
                                <label for="fecha2"
                                    class="block text-sm font-medium leading-6 text-gray-900">Fecha</label>
                                <div class="mt-2">
                                    <input type="date" name="fecha2" id="fecha2" autocomplete="off" required
                                        class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                                </div>
                            </div>
                            <div>
                                <label for="fn2"
                                    class="block text-sm font-medium leading-6 text-gray-900">Fn</label>
                                <div class="mt-2">
                                    <input type="text" name="fn2" id="fn2" autocomplete="off" required
                                        class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                                </div>
                            </div>
                        </div>
                        <div>
                            <div>
                                <label for="codeSIG" class="block text-sm font-medium leading-6 text-gray-900">Código
                                    SIG </label>
                                <div class="mt-2">
                                    <input type="text" name="codeSIG" id="codeSIG" autocomplete="off" required
                                        class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                                </div>
                            </div>

                            <div>
                                <label for="descripcion2"
                                    class="block text-sm font-medium leading-6 text-gray-900">Descripción</label>
                                <div class="mt-2">
                                    <textarea id="descripcion2" name="descripcion2" rows="4" required
                                        class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="w-full flex justify-between mt-4">
                            <button type="button"
                                class="eliminar-btn w-1/3 bg-gray-400 text-white py-2 rounded-md shadow-sm hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Eliminar reporte
                            </button>
                            <button type="submit"
                                class="w-1/3 bg-red-800 text-white py-2 rounded-md shadow-sm hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Actualizar
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div id="editModal" class="fixed inset-0 hidden z-50 overflow-y-auto">
        <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm">
        </div>
        {{-- Control de novedades(extForm) novedades y finalizar tarea --}}
        <div class="flex items-center justify-center min-h-screen">
            <div class="relative w-full max-w-lg rounded-lg shadow bg-white">
                <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-black">
                        Control de novedades
                    </h3>
                    <button type="button"
                        class="text-black bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white"
                        data-modal-hide="finalizado">
                        <i class="fa-solid fa-x"></i>
                    </button>
                </div>
                <div class="p-6 space-y-6">
                    <form method="POST" id="extForm">
                        @csrf
                        @method('PUT')
                        <div>
                            <div>
                                <label for="descripNov"
                                    class="block text-sm font-medium leading-6 text-gray-900">Descripción </label>
                                <input type="text" name="descripNov" id="descripNov" autocomplete="off" required
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                                <span class="font-bold text-red-500 inline-block text-xs">* </span><span
                                    class="text-xs">Los cambios realizados en la descripción sólo serán visibles en
                                    el
                                    reporte de tiempo.</span>
                                <label for="fechaNov"
                                    class="block text-sm font-medium leading-6 text-gray-900">Fecha</label>
                                <input type="date" name="fechaNov" id="fechaNov" autocomplete="off" required
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                                <span class="font-bold text-red-500 inline-block text-xs">* </span><span
                                    class="text-xs">Solo se extenderá la tarea el día seleccionado, la acción no es
                                    consecutiva. </span>
                                <div class="mt-5">
                                    <button type="submit" id="extender-btn"
                                        class="extender-btn w-full bg-red-800 text-white py-2 rounded-md shadow-sm hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                        Extender tarea
                                    </button>

                                    {{-- <input id="newBox" type="checkbox" name="newBox" value="1"
                                        class="w-4 h-4 mt-5 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 focus:ring-2">
                                    <label for="newBox" class="ml-2 text-sm font-medium text-gray-900">¿Desea
                                        agregar un nuevo
                                        registre de reporte de tiempo?</label> --}}
                                    <button type="button"
                                        class="terminar-btn mt-2 w-full bg-red-800 text-white py-2 rounded-md shadow-sm hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">Terminar
                                        tarea</button>

                                </div>

                                <div class="mt-5 text-center">
                                    <p>¿Desea registrar esta tarea como un producto?
                                    </p>
                                </div>
                                <div class="mt-4">
                                    <button type="button"
                                        class="finalizar-btn w-full bg-red-800 text-white py-2 rounded-md shadow-sm hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">Registrar
                                        como producto</button>
                                </div>

                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    <div id="editModal2" class="fixed inset-0 z-50 overflow-y-auto  hidden ">
        <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
        <div class="flex items-center justify-center min-h-screen">
            <div class="relative w-full max-w-lg rounded-lg shadow bg-white">
                <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-black">
                        Guardar producto
                    </h3>
                    <button type="button"
                        class="text-black bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white"
                        data-modal-hide="fin">
                        <i class="fa-solid fa-x"></i>
                    </button>
                </div>
                <div class="p-6 space-y-6">
                    <form id="editForm" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-1 gap-6">
                            <div>
                                <label class="datofecha block text-sm font-medium leading-6 text-gray-900"
                                    for="datofecha">Fecha de creacion</label>
                                <input type="date" id="datofecha" name="datofecha"
                                    class="datofecha block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">

                                <label for="link"
                                    class="block text-sm font-medium leading-6 text-gray-900 ">Link</label>
                                <input type="url" id="link" name="link"
                                    placeholder="Ingrese el Link de sus evidencias cargadas"
                                    class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                                {{-- <input id="checkbox" type="checkbox" name="newTime" value="1"
                                    class="w-4 h-4 mt-2 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 focus:ring-2">
                                <label for="checkbox" class="ml-2 text-sm font-medium text-gray-900">¿dese que se
                                    registre un reporte de tiempo?</label> --}}
                            </div>
                        </div>
                        <div class="mt-5">
                            <button type="submit"
                                class="w-full bg-red-800 text-white py-2 rounded-md shadow-sm hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">Guardar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    </div>
    <div id="fechaModal" class="fixed inset-0 hidden z-50 overflow-y-auto">
        <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
        <div class="flex items-center justify-center min-h-screen">
            <div class="relative w-full max-w-lg rounded-lg shadow bg-white">
                <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-black">
                        Ingresar Fecha
                    </h3>
                    <button type="button"
                        class="text-black bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white"
                        data-modal-hide="fechaModal">
                        <i class="fa-solid fa-x"></i>
                    </button>
                </div>
                <div class="p-6 space-y-6">
                    <form method="POST" action="{{ route('timesheet') }}">
                        @csrf
                        <div class="grid grid-cols-1 gap-6">

                            <div class="grid grid-cols-1 gap-6">
                                <div>
                                    <label for="talento" class="block text-sm font-medium text-gray-900"> Talento
                                        humano
                                    </label>
                                    <select type="select" name="talento" id="talento" required
                                        class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2 border-blue-900">
                                        @if ($talentos->isNotEmpty())
                                            <option value="{{ $talentos->first()->identification }}">
                                                {{ $talentos->first()->name }}</option>
                                        @endif
                                        @foreach ($talentos as $talento)
                                            <option value="{{ $talento->identification }}">{{ $talento->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <label for="aprobador" class="block text-sm font-medium text-gray-900"> Aprobador
                                    </label>
                                    <select type="select" name="aprobador" id="aprobador" required
                                        class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2 border-blue-900">
                                        <option value="">Seleccionar</option>
                                        @foreach ($aprobadores as $aprobador)
                                            <option value="{{ $aprobador->identification }}">{{ $aprobador->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <label for="fecha"
                                        class="block text-sm font-medium text-gray-900">Fecha</label>
                                    <input type="month" name="fecha" id="fecha" required
                                        class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2 border-blue-900">
                                </div>
                            </div>
                            <div class="mt-4">
                                <button type="submit"
                                    class="w-full bg-red-800 text-white py-2 rounded-md shadow-sm hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Generar reporte de tiempo
                                </button>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    </div>
    <div id="fechaReporte" class="fixed inset-0 hidden z-50 overflow-y-auto">
        <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
        <div class="flex items-center justify-center min-h-screen">
            <div class="relative w-full max-w-lg rounded-lg shadow bg-white">
                <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-black">
                        Ingresar Fecha
                    </h3>
                    <button type="button" data-modal-hide="fechaReporte"
                        class="text-black bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white"
                        data-modal-hide="fechaReport">
                        <i class="fa-solid fa-x"></i>
                    </button>
                </div>
                <div class="p-6 space-y-6">
                    <form method="POST" action="{{ route('export') }}">
                        @csrf
                        <div class="grid grid-cols-1 gap-6">
                            <div>
                                <label for="fechaReporte2"
                                    class="block text-sm font-medium text-gray-900">Fecha</label>
                                <input type="month" name="fechaReporte" id="fechaReporte2" required
                                    class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2 border-blue-900">
                            </div>
                        </div>
                        <div class="mt-4">
                            <button
                                class="fecha-btn2 w-full rounded-md bg-red-800 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">
                                Generar Reporte de producto
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="w-11/12 mx-auto py-12">
        <h3 class="text-2xl font-bold text-gray-800 mb-4 border-b-2 border-gray-300 pb-2">
            Historial de tareas registradas
        </h3>

        <div class="mt-8 overflow-x-auto">
            <h3 class="text-center text-2xl font-bold mb-4">
                Calendario de {{ Carbon\Carbon::create(null, $currentMonth)->locale('es')->monthName }}
            </h3>

            <div class="mx-auto grid grid-cols-7 gap-4 text-sm" style="width:1200px">
                <!-- Encabezado de los días de la semana -->
                <div class="font-semibold">Lunes</div>
                <div class="font-semibold">Martes</div>
                <div class="font-semibold">Miercoles</div>
                <div class="font-semibold">Jueves</div>
                <div class="font-semibold">Viernes</div>
                <div class="font-semibold ">Sabado</div>
                <div class="font-semibold">Domigo</div>

                <!-- Días del mes -->
                @foreach ($calendar as $date => $events)
                    @php
                        // Asegúrate de que la fecha esté en un formato válido
                        $carbonDate = \Carbon\Carbon::parse($date);
                        $day = $carbonDate->day; // Obtiene el día del mes
                        $dayOfWeek = \Carbon\Carbon::parse($date)->dayOfWeek;
                        $isWeekend = $dayOfWeek === 0 || $dayOfWeek === 6;
                        $counter = 1;
                    @endphp

                    <div
                        class="p-6 border rounded-lg {{ $events ? 'bg-blue-200 text-blue-700' : 'bg-gray-100' }} {{ $isWeekend ? 'bg-red-100 text-red-700 ' : 'text-black-100' }}">
                        <span class="font-bold text-lg">{{ $day }}</span>
                        @if ($events)
                            @foreach ($events as $event)
                                <div class="text-xs text-gray-500">
                                    {{ $counter }}.
                                    {{ $event['description'] }}
                                </div>
                                @php $counter++; @endphp
                            @endforeach
                        @endif
                    </div>
                @endforeach
            </div>
        </div>


    </div>



    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="{{ asset('js/reporte.js') }}"></script>
    <script>
        let novedadId = null;

        $(document).on('click', '.novedad-btn', function() {
            const id = $(this).data('id');
            novedadId = $(this).data('id');

            const editUrlNov = '{{ route('producto.edit', ':id') }}'.replace(':id', id);

            $.get(editUrlNov, function(data) {
                $('#extForm').attr('action', '{{ route('extender', ':id') }}'.replace(':id', id));
                $('#fechaNov').val(data.date);
                $('#descripNov').val(data.description);
                $('#editModal').removeClass('hidden'); // Asegúrate de que 'editModal' es el ID correcto
            }).fail(function() {
                alert('Error en la carga de datos. Por favor intentelo de nuevo.');
            });
        });
        // Evento para ocultar el modal cuando se hace clic en el botón con atributo [data-modal-hide="fin"]
        $(document).on('click', '[data-modal-hide="finalizado"]', function() {
            $('#editModal').addClass('hidden');
        });

        $(document).on('click', '.finalizar-btn', function() {
            //  const id = $(this).data('id');
            const editUrl = "{{ route('producto.edit', ':id') }}".replace(':id', novedadId);

            $.get(editUrl, function(data) {
                $('#editForm').attr('action', "{{ route('producto.update', ':id') }}".replace(':id',
                    novedadId));
                $('#datofecha').val(data.date);
                $('#link').val(data.link);
                /* $('#editModal2').removeClass('hidden'); */
            }).fail(function() {
                alert('Ha ocurrido un error. Por favor intentelo nuevamente.');
            });
        });

        $(document).on('submit', '#extForm', function(event) {
            event.preventDefault(); // Previene el envío normal del formulario
            const form = $(this);
            const url = form.attr('action');
            const data = form.serialize();

            $.post(url, data)
                .done(function(response) {
                    Swal.fire({
                        title: '¡Éxito!',
                        text: response.success || 'Los datos se actualizaron correctamente.',
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        location.reload(); // Recarga la página después de mostrar la alerta
                    });
                })
                .fail(function(response) {
                    Swal.fire({
                        title: 'Error',
                        text: response.responseJSON.error ||
                            'No se pudieron actualizar los datos. Por favor, intente de nuevo.',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                });


        });

        let currentId = null;

        $(document).on('submit', '#actualizarform', function(event) {
            event.preventDefault(); // Previene el envío normal del formulario

            const form = $(this);
            const url = form.attr('action');
            const data = form.serialize();

            $.post(url, data)
                .done(function(response) {
                    Swal.fire({
                        title: '¡Éxito!',
                        text: response.success || 'Los datos se actualizaron correctamente.',
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        location.reload(); // Recarga la página después de mostrar la alerta
                    });
                })
                .fail(function(response) {
                    Swal.fire({
                        title: 'Error',
                        text: response.responseJSON.error ||
                            'No se pudieron actualizar los datos. Por favor, intente de nuevo.',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                });
        });

        $(document).on('click', '.actualizar-btn', function() {
            currentId = $(this).data('id');
            const id = $(this).data('id');

            const editUrl2 = '{{ route('producto.edit', ':id') }}'.replace(':id', id);

            $.get(editUrl2, function(data) {
                $('#actualizarform').attr('action', '{{ route('actualizar', ':id') }}'.replace(':id',
                    id));
                $('#fecha2').val(data.date);
                $('#fn2').val(data.fn);
                $('#codeSIG').val(data.code_sig);
                $('#descripcion2').val(data.description);
                $('#actualizardiv').removeClass('hidden');
            }).fail(function() {
                alert('Error loading data. Please try again.');
            });
        });
        $(document).on('click', '[data-modal-hide]', function() {
            $('#actualizardiv').addClass('hidden');
        })

        $(document).on('click', '.eliminar-btn', function(event) {
            event.preventDefault(); // Prevenir el comportamiento por defecto
            const deleteUrl = '{{ route('eliminar', ':id') }}'.replace(':id', currentId);

            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción no se puede deshacer.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, eliminar'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(deleteUrl, {
                            method: 'DELETE',
                            headers: {
                                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                'Content-Type': 'application/json'
                            }
                        })
                        .then(response => {
                            if (response.ok) {
                                Swal.fire(
                                    'Eliminado',
                                    'El reporte ha sido eliminado.',
                                    'success'
                                ).then(() => {
                                    location
                                        .reload(); // O actualizar la vista sin recargar la página
                                });
                            } else {
                                Swal.fire(
                                    'Error',
                                    'No se pudo eliminar el reporte.',
                                    'error'
                                );
                            }
                        })
                        .catch(error => {
                            Swal.fire(
                                'Error',
                                'Hubo un problema al eliminar el reporte.',
                                'error'
                            );
                        });
                }
            });
        });
        $(document).on('click', '.terminar-btn', function(event) {
            event.preventDefault();
            //const descripcion = document.getElementById('descripNov').value;
            const terminarURL = '{{ route('terminar', ':id') }}'.replace(':id', novedadId);

            Swal.fire({
                title: '¿Estás seguro?',
                text: "Cuando termina una tarea de esta forma no se reflejara en el reporte de producto",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, estoy seguro'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(terminarURL, {
                            method: 'PUT',
                            headers: {
                                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                'Content-Type': 'application/json'
                            }
                        })
                        .then(response => {
                            if (response.ok) {
                                Swal.fire(
                                    'Finalizado',
                                    'La tarea ha sido terminada.',
                                    'success'
                                ).then(() => {
                                    location
                                        .reload(); // O actualizar la vista sin recargar la página
                                });
                            } else {
                                Swal.fire(
                                    'Error',
                                    'No se pudo terminar el reporte.',
                                    'error'
                                );
                            }
                        })
                        .catch(error => {
                            Swal.fire(
                                'Error',
                                'Hubo un problema al terminar la tarea.',
                                'error'
                            );
                        });
                }
            });
        });


        //////////////////////
        // Mostrar el modal al hacer clic en "Generar Reporte 2"
        document.querySelector('.fecha-btn').addEventListener('click', function() {
            document.getElementById('fechaModal').classList.remove('hidden');
        });
        // Ocultar el modal
        document.querySelector('[data-modal-hide="fechaModal"]').addEventListener('click', function() {
            document.getElementById('fechaModal').classList.add('hidden');
        });

        document.querySelector('.reporte-btn').addEventListener('click', function() {
            document.getElementById('fechaReporte').classList.remove('hidden');
        });
        // Ocultar el modal
        document.querySelector('[data-modal-hide="fechaReporte"]').addEventListener('click', function() {
            document.getElementById('fechaReporte').classList.add('hidden');
        });
    </script>
    <script>
        document.querySelector('.finalizar-btn').addEventListener('click', function() {
            document.getElementById('editModal2').classList.remove('hidden');
        });
        // Ocultar el modal
        document.querySelector('[data-modal-hide="fin"]').addEventListener('click', function() {
            document.getElementById('editModal2').classList.add('hidden');
        });

        function openModal() {
            document.getElementById('add-pms-modal').classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('add-pms-modal').classList.add('hidden');
        }

        function toggleCamposHito() {
            const tipo = document.getElementById('tipo_hito').value;
            document.getElementById('camposSolicitud').classList.toggle('hidden', tipo !==
                'Hito derivado de Solicitudes de Servicio');
            document.getElementById('camposNoPlaneado').classList.toggle('hidden', tipo !==
                'Hito derivado de Requerimientos No Planeados - Directriz');
        }
    </script>
</body>

</html>
