@php
    $rolUsuario = Auth::user()->rol ?? '';
    $activoUsuario = Auth::user()->activo ?? '';
    $vicepresidenciaUsuario = Auth::user()->vicepresidencia ?? '';
    $gerenciaUsuario = Auth::user()->gerencia ?? '';
    $cargoUsuario = Auth::user()->charge ?? '';
    $odsUsuario = Auth::user()->ods ?? 'No asignado';
    $identificacionUsuario = Auth::user()->identification ?? '';
    $nombreUsuario = Auth::user()->name ?? '';
    $emailUsuario = Auth::user()->email ?? '';
    $telefonoUsuario = Auth::user()->phone ?? '';
    $ciudadUsuario = Auth::user()->location ?? '';
    $emailecpUsuario = Auth::user()->emailecp ?? '';
@endphp
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="{{ asset('fontawesome/css/all.min.css') }}">
    <title>Configuración</title>
</head>

<body>

    @include('layout.header')

    <main class="container w-11/12 mx-auto py-12">
        <div class="grid grid-cols-1 px-4 pt-6 xl:grid-cols-3 xl:gap-4 ">
            <div class="mb-4 col-span-full xl:mb-2">
                <h1 class="text-xl font-semibold text-gray-900 sm:text-2xl ">Configuración de usuario
                </h1>
            </div>
            <!-- Right Content -->
            <div class="col-span-full xl:col-auto">

                {{-- cambio de contraseña --}}
                <div class="p-4 mb-4 bg-white border border-gray-200 rounded-lg shadow-sm 2xl:col-span-2 0 sm:p-6 ">
                    <h3 class="mb-4 text-xl font-semibold ">Información de contraseña</h3>
                    <form action="{{ route('cambiarClave.update') }}" method="POST" id="changePasswordForm">
                        @csrf
                        <div class="grid grid-cols-1 gap-6">
                            <div>
                                <label for="current_password"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Contraseña
                                    actual</label>
                                <input name="current_password" type="password" id="current_password"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    placeholder="••••••••" required>
                            </div>
                            <div>
                                <label for="new_password" class="block mb-2 text-sm font-medium text-gray-900 ">Nueva
                                    contraseña</label>
                                <input data-popover-target="popover-password" data-popover-placement="bottom"
                                    name="new_password" type="password" id="new_password"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5   "
                                    placeholder="••••••••" required>
                                <div data-popover id="popover-password" role="tooltip"
                                    class="absolute z-10 invisible inline-block text-sm font-light text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-lg shadow-sm opacity-0 w-72">
                                    <div class="p-3 space-y-2">
                                        <h3 class="font-semibold text-gray-900 ">Debe tener al menos 6
                                            caracteres</h3>
                                    </div>
                                    <div data-popper-arrow></div>
                                </div>
                            </div>
                            <div>
                                <label for="new_password_confirmation"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Confirmar
                                    contraseña</label>
                                <input name="new_password_confirmation" type="password" id="new_password_confirmation"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    placeholder="••••••••" required>
                            </div>
                            {{-- <div class="flex items-center">
                                <input id="show_password" name="show_password" type="checkbox"
                                    class="h-4 w-4 rounded border-gray-300 text-red-800 focus:ring-red-900">
                                <label for="show_password" class="ml-3 min-w-0 flex-1 text-gray-500">Ver
                                    Clave</label>
                            </div> --}}
                            <div>
                                <button
                                    class="text-white bg-red-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center"
                                    type="submit" id="submitBtn">Guardar todo</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-span-2">
                <div class="p-4 mb-4 bg-white border border-gray-200 rounded-lg shadow-sm 2xl:col-span-2  sm:p-6 ">
                    <h3 class="mb-4 text-xl font-semibold ">Información general</h3>
                    <form method="POST" action="#" id="datosGeneralesForm">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-6 gap-6">
                            <div class="col-span-6 sm:col-span-3">
                                <label for="identification" class="block mb-2 text-sm font-medium text-gray-900 ">Id del
                                    usuario</label>
                                <input type="text" name="identification" id="identification"
                                    class="shadow-sm cursor-not-allowed bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    placeholder="{{ $identificacionUsuario }}" disabled>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="name" class="block mb-2 text-sm font-medium text-gray-900 ">Nombre
                                    completo</label>
                                <input type="text" name="name" id="name" value="{{ $nombreUsuario }}"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    required>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="email"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Correo</label>
                                <input type="email" name="email" id="email" value="{{ $emailUsuario }}"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    required>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="email"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Correo Ecopetrol</label>
                                <input type="email" name="emailecp" id="emailecp" value="{{ $emailecpUsuario }}"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    required>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="phone" class="block mb-2 text-sm font-medium text-gray-900 ">Número de
                                    teléfono</label>
                                <input type="number" name="phone" id="phone" value="{{ $telefonoUsuario }}"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    required>
                            </div>
                            {{-- <div class="col-span-6 sm:col-span-3">
                                <label for="location"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Ciudad</label>
                                <input type="text" name="location" id="location" value="{{ $ciudadUsuario }}"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    required>
                            </div> --}}
                            <div class="col-span-6 sm:col-span-3">
                                <label for="location"
                                    class="block mb-2 text-sm font-medium text-gray-900">Ubicación</label>
                                <select name="location" id="location" required
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5">
                                    <option value="ACACÍAS">ACACÍAS</option>
                                    <option value="BARRANCABERMEJA">BARRANCABERMEJA</option>
                                    <option value="BOGOTÁ">BOGOTÁ</option>
                                    <option value="VILLAVICENCIO">VILLAVICENCIO</option>
                                    <option value="YOPAL">YOPAL</option>
                                    <option value="TRABAJO EN CASA">TRABAJO EN CASA</option>
                                </select>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="rol"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Rol</label>
                                <input type="text" name="rol" id="rol"
                                    class="shadow-sm cursor-not-allowed bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    placeholder="{{ $rolUsuario }}" disabled>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="ods"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Ods</label>
                                <input type="text" name="ods" id="ods"
                                    class="shadow-sm cursor-not-allowed bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    placeholder="{{ $odsUsuario }}" disabled>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="cargo"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Cargo</label>
                                <input type="text" name="cargo" id="cargo"
                                    class="shadow-sm cursor-not-allowed bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    placeholder="{{ $cargoUsuario }}" disabled>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="activo"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Activo</label>
                                <input type="text" name="activo" id="activo"
                                    class="shadow-sm cursor-not-allowed bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    placeholder="{{ $activoUsuario }}" disabled>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="vicepresidencia"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Vicepresidencia</label>
                                <input type="text" name="vicepresidencia" id="vicepresidencia"
                                    class="shadow-sm cursor-not-allowed bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    placeholder="{{ $vicepresidenciaUsuario }}" disabled>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="gerencia"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Gerencia</label>
                                <input type="text" name="gerencia" id="gerencia"
                                    class="shadow-sm cursor-not-allowed bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5   "
                                    placeholder="{{ $gerenciaUsuario }}" disabled>
                            </div>
                            <div class="col-span-6 sm:col-full">
                                <button
                                    class="text-white bg-red-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center"
                                    type="submit">Guardar todo</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </main>


    <script src="{{ asset('js/setting.js') }}"></script>
    <script>
        $('#datosGeneralesForm').on('submit', function(e) {
            e.preventDefault();

            const data = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                _method: 'PUT',
                name: $('#name').val(),
                email: $('#email').val(),
                phone: $('#phone').val(),
                location: $('#location').val()
                emailecp: $('#emailecp').val()
            };

            $.ajax({
                url: "{{ route('configuracion.actualizar') }}",
                type: 'PUT',
                data: data,
                success: function(response) {
                    if (response.success) {
                        Swal.fire('Actualizado', response.message, 'success');
                    }
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errorMessages = Object.values(errors).map(msg => msg[0]).join('<br>');
                    Swal.fire('Error', errorMessages, 'error');
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const locationSelect = document.getElementById('location');
            const currentLocation = @json($ciudadUsuario);

            if (currentLocation) {
                locationSelect.value = currentLocation;
            }
        });
    </script>

</body>

</html>
