<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <title>Reporte</title>
</head>

<body>
    @include('layout.header')

    <div class="mt-8 max-w-7xl mx-auto p-4 bg-white shadow-md rounded-lg">
        <form method="GET" action="{{ route('history') }}" class="mb-6">
            <div class="flex items-center space-x-4">
                <label for="filterDate" class="font-semibold text-gray-700">Filtrar por Fecha:</label>
                <input type="month" id="filterDate" name="filterDate"
                    class="border border-gray-300 p-2 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                <button type="submit"
                    class="bg-green-500 text-white px-4 py-2 rounded-md hover:bg-green-600 transition duration-300">
                    Filtrar
                </button>
            </div>
        </form>

        <div class="overflow-x-auto">
            <table id="miTabla" class="min-w-full bg-white shadow-md rounded-lg">
                <thead class="bg-gray-200 text-gray-700">
                    <tr>
                        <th class="py-3 px-6 border-b text-left">Numero</th>
                        <th class="py-3 px-6 border-b text-left">Ubicacion</th>
                        <th class="py-3 px-6 border-b text-left">Fecha</th>
                        <th class="py-3 px-6 border-b text-left">Descripción</th>
                        <th class="py-3 px-6 border-b text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $i = 1;
                    @endphp
                    @foreach ($reportes as $reporte)
                        <tr class="bg-white border-b hover:bg-gray-50">
                            <td class="py-4 px-6">{{ $i }}</td>
                            <td class="py-4 px-6">{{ $reporte->location }}</td>
                            <td class="py-4 px-6">{{ $reporte->date }}</td>
                            <td class="py-4 px-6">{{ $reporte->description }}</td>
                            <td class="py-4 px-6 text-center space-x-2">
                                <button type="button"
                                    class="editar-btn bg-green-500 text-white px-4 py-2 rounded-md hover:bg-green-600 transition duration-300"
                                    data-id="{{ $reporte->id }}">Editar</button>
                            </td>
                        </tr>
                        @php
                            $i++;
                        @endphp
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div id="editarFunc" class="fixed inset-0 hidden z-50 overflow-y-auto">
        <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
        <div class="flex items-center justify-center min-h-screen">
            <div class="relative w-full max-w-lg rounded-lg shadow bg-white">
                <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-black">
                        Editar reporte
                    </h3>
                    <button type="button"
                        class="text-black bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white"
                        data-modal-hide="editarFunc">
                        <i class="fa-solid fa-x"></i>
                    </button>
                </div>
                <div class="p-6 space-y-6">
                    <form method="POST" id="actualizarFunc">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                            <div>
                                <label for="fecha"
                                    class="block text-sm font-medium leading-6 text-gray-900">Fecha</label>
                                <div class="mt-2">
                                    <input type="date" name="fecha" id="fecha" autocomplete="off" required
                                        class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                                </div>
                            </div>
                        </div>
                        <div>
                            <div>
                                <label for="descripcion"
                                    class="block text-sm font-medium leading-6 text-gray-900">Descripción</label>
                                <div class="mt-2">
                                    <textarea id="descripcion" name="descripcion" rows="4" required
                                        class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="w-full flex justify-between mt-4">
                            <button type="button"
                                class="eliminar-btn w-1/3 bg-gray-400 text-white py-2 rounded-md shadow-sm hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Eliminar reporte
                            </button>
                            <button type="submit"
                                class="w-1/3 bg-red-800 text-white py-2 rounded-md shadow-sm hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Actualizar
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        let currentId = null;
        $(document).on('click', '.editar-btn', function() {
            const id = $(this).data('id');
            currentId = $(this).data('id');
            const editarUrl = '{{ route('historyedith', ':id') }}'.replace(':id', id);

            $.get(editarUrl, function(data) {
                $('#actualizarFunc').attr('action', '{{ route('historyact', ':id') }}'.replace(':id', id));
                $('#fecha').val(data.date);
                $('#descripcion').val(data.description);
                $('#editarFunc').removeClass('hidden');
            }).fail(function() {
                alert('Error loading data. Please try again.');
            });
        });
        // Ocultar el modal
        document.querySelector('[data-modal-hide="editarFunc"]').addEventListener('click', function() {
            document.getElementById('editarFunc').classList.add('hidden');
        });

        $(document).on('submit', '#actualizarFunc', function(event) {
            event.preventDefault(); // Previene el envío normal del formulario

            const form = $(this);
            const url = form.attr('action');
            const data = form.serialize();

            $.post(url, data)
                .done(function(response) {
                    Swal.fire({
                        title: '¡Éxito!',
                        text: response.success || 'Los datos se actualizaron correctamente.',
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        location.reload(); // Recarga la página después de mostrar la alerta
                    });
                })
                .fail(function(response) {
                    Swal.fire({
                        title: 'Error',
                        text: response.responseJSON.error ||
                            'No se pudieron actualizar los datos. Por favor, intente de nuevo.',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                });
        });

        $(document).on('click', '.eliminar-btn', function(event) {
            event.preventDefault(); // Prevenir el comportamiento por defecto
            const deleteUrl = '{{ route('delle', ':id') }}'.replace(':id', currentId);

            Swal.fire({
                title: '¡Advertencia!',
                text: "Si elimina un reporte de tiempo este no se vera reflejado en el reprote final.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, estoy seguro.'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(deleteUrl, {
                            method: 'DELETE',
                            headers: {
                                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                'Content-Type': 'application/json'
                            }
                        })
                        .then(response => {
                            if (response.ok) {
                                Swal.fire(
                                    'Eliminado',
                                    'El reporte ha sido eliminado.',
                                    'success'
                                ).then(() => {
                                    location
                                        .reload(); // O actualizar la vista sin recargar la página
                                });
                            } else {
                                Swal.fire(
                                    'Error',
                                    'No se pudo eliminar el reporte.',
                                    'error'
                                );
                            }
                        })
                        .catch(error => {
                            Swal.fire(
                                'Error',
                                'Hubo un problema al eliminar el reporte.',
                                'error'
                            );
                        });
                }
            });
        });

        /* $(document).on('click', '.eliminar-btn', function(event) {
                event.preventDefault(); // Prevenir el comportamiento por defecto
                const deleteUrl = '{{ route('delle', ':id') }}'.replace(':id', currentId);

                Swal.fire({
                    title: '¡Advertencia!',
                    text: "Si elimina una reporte de producto los reportes de tiempo relacionados seran eliminados.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Sí, estoy seguro.'
                }).then((result) => {
                    if (result.isConfirmed) {
                        fetch(deleteUrl, {
                                method: 'DELETE',
                                headers: {
                                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                                    'Content-Type': 'application/json'
                                }
                            })
                            .then(response => {
                                if (response.ok) {
                                    Swal.fire(
                                        'Eliminado',
                                        'El reporte ha sido eliminado.',
                                        'success'
                                    ).then(() => {
                                        location
                                            .reload(); // O actualizar la vista sin recargar la página
                                    });
                                } else {
                                    Swal.fire(
                                        'Error',
                                        'No se pudo eliminar el reporte.',
                                        'error'
                                    );
                                }
                            })
                            .catch(error => {
                                Swal.fire(
                                    'Error',
                                    'Hubo un problema al eliminar el reporte.',
                                    'error'
                                );
                            });
                    }
                });
            }); */
    </script>
