<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid black;
            font-size: 8;
        }

        th,
        td {
            border: 3px solid black;
            text-align: center;
            padding: 5px;
            border: 2px solid black;
        }

        th {
            background-color: #f2f2f2;
        }

        .header-table,
        .header-table td {
            border: none;
        }
    </style>
    @php
        use Carbon\Carbon;
        use Rmunate\Calendar\Colombia;

        Carbon::setLocale('es');

        // Mes y año que deseas (por ejemplo, julio de 2023)
        $fechaSeleccionada = Carbon::parse($fechaSeleccionada); // Asegúrate de que $fechaSeleccionada es una fecha válida
        $chosenMonth = $fechaSeleccionada->month; // Extrae el mes
        $chosenYear = $fechaSeleccionada->year; // Extrae el año

        // Crear una instancia de Carbon para la fecha elegida
        $chosenDate = Carbon::create($chosenYear, $chosenMonth, 1);

        // Obtener el nombre del mes en español y capitalizar la primera letra
        $daysInMonth = $chosenDate->daysInMonth; // Número de días en el mes elegido
        $year = $chosenDate->year; // Año elegido
        $month = $chosenDate->month;
        $monthName = ucfirst($chosenDate->translatedFormat('F')); // Nombre del mes con primera letra en mayúscula

        $total_dias_laborados = 0;
        $total_horas_laboradas = 0;
        $total_horas_por_dia = 8.5;

        $total_minutos = $total_horas_por_dia * 60; // Convertir horas a minutos
        $hora_muestra = floor($total_minutos / 60); // Horas completas
        $minuta = $total_minutos % 60; // Minutos restantes

        // Formato final: Horas:minutos (ej. 5h 30m)
        $formatoDE = sprintf('%02d : %02d', $hora_muestra, $minuta);

        $ods = $users->first()->ods;
        // Obtener la fecha completa del último día del mes
        $lastDayOfMonth = $chosenDate->endOfMonth();
        $lastday = $lastDayOfMonth->format('Y-m-d'); // Formato de fecha: año-mes-día

        $fecha = Carbon::now()->toDateString();

    @endphp
</head>

<body>
    <table class="header-table">
        <tr>
            <td colspan="3" rowspan="4" style="border: 1px solid black;"></td>
            <td colspan="5" rowspan="2" style="border: 1px solid black">INGICAT SAS</td>
            <td style="border: 1px solid black;text-align: right;" colspan="2">DOCUMENTO No.</td>
        </tr>
        <tr>
            <td colspan="2"style="border: 1px solid black"> 01</td>
        </tr>
        <tr>
            <td colspan="5" rowspan="2"style="border: 1px solid black">REPORTE DE TIEMPO</td>
            <td style="border: 1px solid black; text-align: right;" colspan="2">Versión</td>
        </tr>
        <tr>
            <td colspan="2"style="border: 1px solid black"> 01</td>
        </tr>
    </table>
    <table>
        <tr>
            <td colspan="2"style="border: 1px solid black; text-align: left">CLIENTE:</td>
            <td colspan="8"style="border: 1px solid black; text-align: left">Ecopetrol</td>
        </tr>
        <tr>
            <td colspan="2"style="border: 1px solid black; text-align: left">MES:</td>
            <td colspan="8"style="border: 1px solid black; text-align: left">{{ $monthName }}</td>
        </tr>
        <tr>
            <td colspan="2"style="border: 1px solid black; text-align: left">ODS:</td>
            <td colspan="8"style="border: 1px solid black; text-align: left">{{ $ods }}</td>
        </tr>
        <tr>
            <td colspan="2"style="border: 1px solid black; text-align: left">AÑO:</td>
            <td colspan="8"style="border: 1px solid black; text-align: left">{{ $year }}</td>
        </tr>
    </table>

    <table>
        <thead>
            <tr style="border:black; color:#f2f2f2">
                <th rowspan="2"
                    style="background-color: #a00404; text-align:center;border: 1px solid black; color:#f2f2f2">Dia</th>
                <th rowspan="2"
                    style="background-color: #a00404; text-align:center;border: 1px solid black; color:#f2f2f2">
                    Municipio</th>
                <th colspan="2"
                    style="background-color: #a00404; text-align:center;border: 1px solid black; color:#f2f2f2">Hora en
                    la mañana</th>
                <th colspan="2"
                    style="background-color: #a00404; text-align:center;border: 1px solid black; color:#f2f2f2">Hora en
                    la tarde</th>
                <th rowspan="2"
                    style="background-color: #a00404; text-align:center;border: 1px solid black; color:#f2f2f2">Total
                    Horas / dia</th>
                <th rowspan="2"
                    style="background-color: #a00404; text-align:center;border: 1px solid black; color:#f2f2f2"
                    colspan="3">Actividades</th>
            </tr>
            <tr>
                <th style="background-color: #a00404;border: 1px solid black;; color:#f2f2f2">Ingreso</th>
                <th style="background-color: #a00404 ;border: 1px solid black;; color:#f2f2f2">Salida</th>
                <th style="background-color: #a00404 ;border: 1px solid black;; color:#f2f2f2">Ingreso</th>
                <th style="background-color: #a00404 ;border: 1px solid black;; color:#f2f2f2">Salida</th>
            </tr>
        </thead>
        <tbody>

            @for ($i = 1; $i <= $daysInMonth; $i++)
                @php
                    $date = \Carbon\Carbon::createFromDate($year, $month, $i);
                    $isWeekend = $date->isWeekend();
                    $isSaturday = $date->isSaturday();
                    $isSunday = $date->isSunday();
                    $isHoliday = Colombia::isHoliday($date->format('Y-m-d'));
                    $isLaborado = true;
                    $totalHours = $isWeekend && $isHoliday ? '00:00' : $formatoDE;

                    // Manejo de horas
                    /* $morningStart = $isWeekend ? '00:00' : '07:30';
                    $morningEnd = $isWeekend ? '00:00' : '12:00';
                    $afternoonStart = $isWeekend ? '00:00' : '01:00';
                    $afternoonEnd = $isWeekend ? '00:00' : '05:00';
                    $totalHours = $isWeekend ? '00:00' : $formatoDE;
                    $isLaborado = true; // Inicializa como true */
                    $date = \Carbon\Carbon::createFromDate($year, $month, $i);
                    // Manejo de horas
                    if ($isWeekend || $isHoliday) {
                        // Si es fin de semana o festivo, no marcar horas
                        $morningStart = '00:00';
                        $morningEnd = '00:00';
                        $afternoonStart = '00:00';
                        $afternoonEnd = '00:00';
                        $isLaborado = false;
                    } else {
                        // Si no es fin de semana ni festivo, marcar horario normal
                        $morningStart = '07:30';
                        $morningEnd = '12:00';
                        $afternoonStart = '13:00'; // Asumí que querías '13:00' en lugar de '01:00'
                        $afternoonEnd = '17:00';
                        $isLaborado = true; // Inicializa como true
                        $totalHours = $formatoDE; // Asegúrate que $formatoDE tenga el formato correcto
                    }

                    // Informes diarios
                    $dailyReports = $reports->get($date->toDateString(), collect()); // Asegurar que sea una colección
                    $locations = $dailyReports->pluck('location')->unique()->implode(', ') ?? 'N/A';
                    $descriptions = $dailyReports->pluck('description')->implode("\n") ?? '';
                    $descriptions = htmlspecialchars($descriptions, ENT_QUOTES, 'UTF-8');
                    $descriptions = nl2br($descriptions); //se agrego caracteres extraños a la pagina.

                    // Si es fin de semana, establecer la descripción como "sábado" o "domingo"
                    if ($isSaturday) {
                        $descriptions = 'Sábado';
                    } elseif ($isSunday) {
                        $descriptions = 'Domingo';
                    } elseif ($isHoliday) {
                        $descriptions = 'Festivo'; // Si es festivo
                    } elseif (!$isWeekend && empty($descriptions)) {
                        // Si no es fin de semana y no hay descripción, establecer "no laborado"
                        $descriptions = 'No laborado';
                        $isLaborado = false;
                    }

                    // Cálculo de días laborados y horas laboradas
                    if (!$isWeekend && $isLaborado) {
                        $total_dias_laborados++;
                        $total_horas_laboradas += $total_horas_por_dia;
                    }

                    // Ajustar horas y totalHours si no se laboró
                    $morningStart = $isLaborado ? $morningStart : '00:00';
                    $morningEnd = $isLaborado ? $morningEnd : '00:00';
                    $afternoonStart = $isLaborado ? $afternoonStart : '00:00';
                    $afternoonEnd = $isLaborado ? $afternoonEnd : '00:00';
                    $totalHours = $isLaborado ? $totalHours : '00:00';

                    // Convertir horas a formato de horas y minutos
                    $totalHoursInMinutes = $total_horas_laboradas * 60; // Convertir horas a minutos
                    $hours = floor($totalHoursInMinutes / 60); // Horas completas
                    $minutes = $totalHoursInMinutes % 60; // Minutos restantes

                    // Formato final: Horas:minutos (ej. 5h 30m)
                    $formattedTotalHours = sprintf('%02d : %02d', $hours, $minutes);

                @endphp
                <tr>
                    <td style="border: 1px solid black ; text-align: center;width: 20px">{{ $i }}</td>
                    <td style="border: 1px solid black; text-align: center;width: 40px">{{ $locations }}</td>
                    <td style="border: 1px solid black; text-align: center;width: 20px">{{ $morningStart }}</td>
                    <td style="border: 1px solid black; text-align: center;width: 20px">{{ $morningEnd }}</td>
                    <td style="border: 1px solid black; text-align: center; text-align: center;width: 20px">
                        {{ $afternoonStart }}
                    </td>
                    <td style="border: 1px solid black; text-align: center;width: 20px">{{ $afternoonEnd }}</td>
                    <td style="border: 1px solid black; text-align: center;width: 20px">{{ $totalHours }}</td>
                    <td colspan="3" style="border: 1px solid black;width: 20px">{!! $descriptions !!}</td>
                </tr>
            @endfor
        </tbody>
    </table>
    {{-- <script>
        // Usamos PHP para insertar el valor de la variable en JavaScript
        var mensaje = "<?php echo $isHoliday; ?>";
        console.log(mensaje);
    </script> --}}
    @php
        // Información del usuario
        $usuario = $users->flatten();
        $name = $usuario->pluck('name')->implode('') ?? 'N/A';
        $cc = $usuario->pluck('identification')->unique()->implode('') ?? 'N/A';
        $charge = $usuario->pluck('charge')->unique()->implode('') ?? 'N/A';
    @endphp

    <table>
        <tr>
            <th colspan="2" style="border: 1px solid black">TOTAL DÍAS LABORADOS:</th>
            <td style="border: 1px solid black">{{ $total_dias_laborados }}</td>
            <td></td>
            <th colspan="2" style="border: 1px solid black; text-align: left">TOTAL HORAS LABORADAS:</th>
            <td style="border: 1px solid black; text-align: left">{{ $formattedTotalHours }}</td>
            <th colspan="2" style="border: 1px solid black; text-align: left">FECHA:</th>
            <td style="border: 1px solid black; text-align: left">{{ $lastday }}</td>
        </tr>
        <tr></tr>
        <tr>
            <th colspan="10" rowspan="4" style="border: 1px solid black">Observaciones:</th>
        </tr>
        <tr> </tr>
    </table>
    <br>
    <table>
        <tr></tr>
        <tr>
            <td colspan="10" rowspan="2" style="; text-align: left">
                <p>La jornada máxima legal corresponde de lunes a sabado, ocho (8) horas laborales diarias. El trabajo
                    extra debe ser autorizado previamente por el profesional de programación y control del proyecto
                    quien a su vez solicitaráautorización al cliente, de lo contrario no será reconocido el tiempo
                    extra.</p>
            </td>
        </tr>
        <tr></tr>
        <tr>
            <th colspan="4" style="border: 1px solid black, text-align: left">FUNCIONARIO</th>
            <th colspan="3" style="border: 1px solid black, text-align: left">APROBADO POR</th>
            <th colspan="3"style="border: 1px solid black, text-align: left">TALENTO HUMANO</th>
        </tr>
        <tr>
            <td colspan="2" style="border: 1px solid black, text-align: left">NOMBRE</td>
            <td colspan="2" style="border: 1px solid black, text-align: left">{{ $name }}</td>
            <td style="border: 1px solid black, text-align: left">NOMBRE</td>
            <td colspan="2" style="border: 1px solid black, text-align: left">{{ $aprobadorData['name'] }}</td>
            <td style="border: 1px solid black, text-align: left">NOMBRE</td>
            <td colspan="2" style="border: 1px solid black, text-align: left">{{ $talentoData['name'] }}</td>

        </tr>
        <tr>
            <td colspan="2" style="border: 1px solid black, text-align: left">C.C.</td>
            <td colspan="2" style="border: 1px solid black; text-align: left">{{ $cc }}</td>
            <td style="border: 1px solid black, text-align: left">C.C.</td>
            <td colspan="2" style="border: 1px solid black, text-align: left">{{ $aprobadorData['identification'] }}
            </td>
            <td style="border: 1px solid black, text-align: left">C.C.</td>
            <td colspan="2" style="border: 1px solid black, text-align: left">{{ $talentoData['identification'] }}
            </td>
        </tr>
        <tr>
            <td colspan="2" style="border: 1px solid black, text-align: left">CARGO</td>
            <td colspan="2" style="border: 1px solid black, text-align: left">{{ $charge }}</td>
            <td style="border: 1px solid black, text-align: left">CARGO</td>
            <td colspan="2" style="border: 1px solid black, text-align: left">{{ $aprobadorData['charge'] }}</td>
            <td style="border: 1px solid black, text-align: left">CARGO</td>
            <td colspan="2" style="border: 1px solid black, text-align: left">{{ $talentoData['charge'] }}</td>
        </tr>
        <tr>
            <td colspan="2" style="border: 1px solid black, text-align: left">FIRMA</td>
            <td colspan="2" style="border: 1px solid black, text-align: left"></td>
            <td style="border: 1px solid black, text-align: left">FIRMA</td>
            <td colspan="2" style="border: 1px solid black, text-align: left"></td>
            <td style="border: 1px solid black, text-align: left">FIRMA</td>
            <td colspan="2" style="border: 1px solid black, text-align: left"></td>
        </tr>
    </table>
</body>

</html>
