<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link rel="stylesheet" href="{{ asset('fontawesome/css/all.min.css') }}">
    <title>Usuarios</title>
</head>

<body>
    @include('layout.header')

    <div class="container w-11/12 mx-auto py-12">
        <div class="relative overflow-hidden bg-white shadow-md sm:rounded-lg">
            <div
                class="flex flex-col px-4 py-3 space-y-3 lg:flex-row lg:items-center lg:justify-between lg:space-y-0 lg:space-x-4">
                <div class="flex items-center flex-1 space-x-4">
                    <form class="lg:pr-3" action="#" method="GET">
                        <label for="UsuarioBus" class="sr-only">Search</label>
                        <div class="relative mt-1 lg:w-64 xl:w-96">
                            <input type="text" name="text" id="UsuarioBus"
                                class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                                placeholder="ID de usuario | Correo electronico">
                        </div>
                    </form>
                </div>
                <div
                    class="flex flex-col flex-shrink-0 space-y-3 md:flex-row md:items-center lg:justify-end md:space-y-0 md:space-x-3">
                    <button type="button" id="openAddUserModal" data-modal-target="add-user-modal"
                        data-modal-toggle="add-user-modal" data-modal-toggle="createProductModal"
                        class="flex bg-red-700 items-center justify-center px-4 py-2 text-sm font-medium text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 focus:outline-none ">
                        <svg class="h-3.5 w-3.5 mr-2" fill="currentColor" viewbox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                            <path clip-rule="evenodd" fill-rule="evenodd"
                                d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" />
                        </svg>
                        Añadir nuevo usuario
                    </button>
                    <button type="button" id="importUserModalButton" data-modal-target="importUserModal"
                        data-modal-toggle="importUserModal"
                        class="flex items-center justify-center flex-shrink-0 px-3 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg focus:outline-none hover:bg-gray-100 hover:text-primary-700 focus:z-10 focus:ring-4 focus:ring-gray-200">
                        <svg class="w-4 h-4 mr-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewbox="0 0 24 24"
                            stroke-width="2" stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M3 16.5v2.25A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75V16.5m-13.5-9L12 3m0 0l4.5 4.5M12 3v13.5" />
                        </svg>
                        Importar
                    </button>
                </div>
            </div>
            <div id="TableUsers">
                @include('partials.tablaUsuarios')
            </div>
        </div>
    </div>

    {{-- modales de registro de usuario, importacion de usuarios y editar usuario --}}
    <!-- Agregar Usuario Modal -->
    <div class="fixed left-0 right-0 z-50 items-center justify-center hidden overflow-x-hidden overflow-y-auto top-4 md:inset-0 h-modal sm:h-full"
        id="add-user-modal">
        <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
        <div class="relative w-full max-w-4xl px-4 max-h-[95vh] overflow-y-auto">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow">
                <!-- Modal header -->
                <div class="flex items-start justify-between p-5 border-b rounded-t">
                    <h3 class="text-xl font-semibold">
                        Agregar nuevo usuario
                    </h3>
                    <button type="button" id="closeAddUserModal"
                        class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center"
                        data-modal-toggle="add-user-modal">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </div>
                <!-- Modal body -->
                <form id="UserForm" action="{{ route('usuario.store') }}" method="POST">
                    @csrf
                    <div class="p-6 space-y-6">
                        <div class="grid grid-cols-6 gap-3">
                            <div class="col-span-6 sm:col-span-2">
                                <label for="identification" class="block mb-2 text-sm font-medium text-gray-900 ">Id del
                                    usuario <strong class=" text-red-600">*</strong></label>
                                <input type="number" name="identification" id="identification" autocomplete="off"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 "
                                    placeholder="ej. 123456789" required>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="name" class="block mb-2 text-sm font-medium text-gray-900 ">Nombre
                                    completo <strong class=" text-red-600">*</strong></label>
                                <input type="text" name="name" id="name" autocomplete="off"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 "
                                    placeholder="ej. Yonatan David" required>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="email" class="block mb-2 text-sm font-medium text-gray-900 ">Correo
                                    <strong class=" text-red-600">*</strong></label>
                                <input type="email" name="email" id="email" autocomplete="off"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 "
                                    placeholder="ej. example@example.com" required>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="emailecp" class="block mb-2 text-sm font-medium text-gray-900 ">Correo Ecopetrol
                                    <strong class=" text-red-600">*</strong></label>
                                <input type="email" name="emailecp" id="emailecp" autocomplete="off"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 "
                                    placeholder="ej. example@example.com" required>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="phone" class="block mb-2 text-sm font-medium text-gray-900 ">Teléfono
                                    <strong class=" text-red-600">*</strong></label>
                                <input type="number" name="phone" id="phone" autocomplete="off"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 "
                                    placeholder="ej. 1234567899" required>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="rol" class="block mb-2 text-sm font-medium text-gray-900 ">Rol
                                    <strong class=" text-red-600">*</strong></label>
                                <select id="rol" name="rol" required
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 ">
                                    <option value="">Seleccionar</option>
                                    <option value="Administrador">Administrador</option>
                                    <option value="Usuario">Usuario</option>
                                    <option value="Planeador">Planeador</option>
                                    <option value="Hse">Hse</option>
                                </select>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="charge" class="block mb-2 text-sm font-medium text-gray-900 ">Cargo
                                    <strong class=" text-red-600">*</strong></label>
                                <select id="charge" name="charge" required
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 ">
                                    <option selected="">Seleccionar categoria</option>
                                    @foreach ($charges as $charge)
                                        <option value="{{ $charge->charge }}">{{ $charge->charge }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="orden" class="block mb-2 text-sm font-medium text-gray-900 ">Ods
                                    <strong class=" text-red-600">*</strong></label>
                                <input type="text" name="ods" id="orden"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 "
                                    placeholder="ej. xx" required>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="location" class="block mb-2 text-sm font-medium text-gray-900 ">Ubicación
                                    <strong class=" text-red-600">*</strong></label>
                                <select id="location" name="location" required
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 ">
                                    <option value="">Seleccionar</option>
                                    <option value="ACACÍAS">ACACIÁS</option>
                                    <option value="BARRANCABERMEJA">BARRANCABERMEJA</option>
                                    <option value="BOGOTÁ">BOGOTÁ</option>
                                    <option value="VILLAVICENCIO">VILLAVICENCIO</option>
                                    <option value="YOPAL">YOPAL</option>
                                    <option value="TRABAJO EN CASA">TRABAJO EN CASA</option>
                                </select>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="activo" class="block mb-2 text-sm font-medium text-gray-900 ">Activo
                                    <strong class=" text-red-600">*</strong></label>
                                <select id="activo" name="activo" required
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 ">
                                    <option value="">Seleccionar</option>
                                    <option value="Administrativo ECP">Administrativo ECP</option>
                                    <option value="Apiay">Apiay</option>
                                    <option value="Casabe">Casabe</option>
                                    <option value="Castilla">Castilla</option>
                                    <option value="Catenare">Catenare</option>
                                    <option value="Chichimene">Chichimene</option>
                                    <option value="CPO9">CPO9</option>
                                    <option value="ELC-GRB">ELC-GRB</option>
                                    <option value="Floreña">Floreña</option>
                                    <option value="Invasiones">Invasiones</option>
                                    <option value="Lisama">Lisama</option>
                                    <option value="Llanito">Llanito</option>
                                    <option value="Nacional">Nacional</option>
                                    <option value="Provincia">Provincia</option>
                                    <option value="Transversal">Transversal</option>
                                </select>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="vicepresidencia"
                                    class="block mb-2 text-sm font-medium text-gray-900 ">Vicepresidencia <strong
                                        class=" text-red-600">*</strong></label>
                                <select id="vicepresidencia" name="vicepresidencia" required
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 ">
                                    <option value="">Seleccionar</option>
                                    <option value="Administrativo">Administrativo</option>
                                    <option value="Invasiones">Invasiones</option>
                                    <option value="Nacional">Nacional</option>
                                    <option value="Transversal">Transversal</option>
                                    <option value="VPI">VPI</option>
                                    <option value="VRC">VRC</option>
                                    <option value="VRO">VRO</option>
                                </select>
                            </div>
                            <div class="col-span-6 sm:col-span-2">
                                <label for="gerencia" class="block mb-2 text-sm font-medium text-gray-900 ">Gerencia
                                    <strong class=" text-red-600">*</strong></label>
                                <select id="gerencia" name="gerencia" required
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 ">
                                    <option value="">Seleccionar</option>
                                    <option value="Administrativo">Administrativo</option>
                                    <option value="GCH">GCH</option>
                                    <option value="GDP">GDP</option>
                                    <option value="GDT">GDT</option>
                                    <option value="GLC">GLC</option>
                                    <option value="GMA">GMA</option>
                                    <option value="GRI">GRI</option>
                                    <option value="GTA">GTA</option>
                                    <option value="Invasiones">Invasiones</option>
                                    <option value="Nacional">Nacional</option>
                                    <option value="Transversal">Transversal</option>
                                </select>
                            </div>
                        </div>
                        <!-- Modal footer -->
                    </div>
                    <div class="items-center p-6 border-t border-gray-200 rounded-b">
                        <button
                            class="text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800"
                            type="submit">Agregar usuario</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Agregar editar Modal -->
    <div id="editUsers"
        class="fixed inset-0 z-50 flex items-center justify-center hidden overflow-x-hidden overflow-y-auto top-4 md:inset-0 h-modal sm:h-full">
        <div class="relative w-full h-full max-w-2xl px-4 md:h-auto">
            <!-- Modal content -->
            <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
            <div class="relative bg-white rounded-lg shadow">
                <!-- Modal header -->
                <div class="flex items-start justify-between p-5 border-b rounded-t">
                    <h3 class="text-xl font-semibold">
                        Editar usuario
                    </h3>
                    <button type="button"
                        class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center"
                        data-modal-edit="editUsers">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-6 space-y-6">
                    <form method="POST" id="updateUserEdit">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-6 gap-6">
                            <div class="col-span-6 sm:col-span-3">
                                <label for="name"
                                    class="block mb-2 text-sm font-medium text-gray-900">Nombre</label>
                                <input type="text" name="edit_name" id="edit_name"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                                    required>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="email"
                                    class="block mb-2 text-sm font-medium text-gray-900">Correo</label>
                                <input type="email" name="edit_email" id="edit_email"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                                    required>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="emailecp"
                                    class="block mb-2 text-sm font-medium text-gray-900">Correo Ecopetrol</label>
                                <input type="email" name="edit_emailecp" id="edit_emailecp"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                                    required>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="phone"
                                    class="block mb-2 text-sm font-medium text-gray-900">Teléfono</label>
                                <input type="text" name="edit_phone" id="edit_phone"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                                    required>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="edit_ods"
                                    class="block mb-2 text-sm font-medium text-gray-900">Ods</label>
                                <input type="text" name="edit_ods" id="edit_ods"
                                    class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                                    required>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="edit_rol"
                                    class="block mb-2 text-sm font-medium text-gray-900">Rol</label>
                                <select name="edit_rol" id="edit_rol"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5">
                                    {{-- <option value="">Seleccionar</option> --}}
                                    <option value="Administrador">Administrador</option>
                                    <option value="Usuario">Usuario</option>
                                    <option value="Planeador">Planeador</option>
                                    <option value="Hse">Hse</option>
                                </select>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="edit_charge"
                                    class="block mb-2 text-sm font-medium text-gray-900">Cargo</label>
                                <select name="edit_charge" id="edit_charge"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5">
                                    <option selected="">Seleccionar categoria</option>
                                    <option value="COORDINADOR TECNICO">COORDINADOR TECNICO</option>
                                    <option value="SERVICIO GESTIÓN DOCUMENTAL">SERVICIO GESTIÓN DOCUMENTAL</option>
                                    <option value="SERVICIO DE GESTIÓN INTEGRAL LEGAL">SERVICIO DE GESTIÓN INTEGRAL
                                        LEGAL</option>
                                    <option value="SERVICIO INTEGRAL DE GESTIÓN DE TIERRAS">SERVICIO INTEGRAL DE
                                        GESTIÓN DE TIERRAS</option>
                                    <option value="SERVICIO INTEGRAL EVALUACIÓN">SERVICIO INTEGRAL EVALUACIÓN</option>
                                    <option value="SERVICIO INTEGRAL SIG">SERVICIO INTEGRAL SIG</option>
                                    <option value="SERVICIO BÁSICO EVALUACIÓN">SERVICIO BÁSICO EVALUACIÓN</option>
                                    <option value="SERVICIO ESPECIALIZADO DE GESTIÓN DE TIERRAS">SERVICIO ESPECIALIZADO
                                        DE GESTIÓN DE TIERRAS</option>
                                    <option value="SERVICIO ESTRUCTURACIÓN VALORACIÓN">SERVICIO ESTRUCTURACIÓN
                                        VALORACIÓN</option>
                                    <option value="SERVICIO DE GESTIÓN EXPERTO LEGAL">SERVICIO DE GESTIÓN EXPERTO LEGAL
                                    </option>
                                    <option value="SERVICIO EXPERTO DE GESTIÓN DE TIERRAS">SERVICIO EXPERTO DE GESTIÓN
                                        DE TIERRAS</option>
                                    <option value="SERVICIO ESPECIALIZADO PROCESAMIENTO SIG">SERVICIO ESPECIALIZADO
                                        PROCESAMIENTO SIG</option>
                                    <option value="SERVICIO EXPERTO DESARROLLO">SERVICIO EXPERTO DESARROLLO</option>
                                    <option value="SERVICIO EXPERTO PLANEACIÓN PROCESO">SERVICIO EXPERTO PLANEACIÓN
                                        PROCESO</option>
                                    <option value="SERVICIO EXPERTO EN DISEÑO SIG">SERVICIO EXPERTO EN DISEÑO SIG
                                    </option>
                                    <option value="SERVICIO ESPECIALIZADO CONTROL PROYECTO">SERVICIO ESPECIALIZADO
                                        CONTROL PROYECTO</option>
                                    <option value="SERVICIO DE GESTIÓN ESPECIALIZADO LEGAL">SERVICIO DE GESTIÓN
                                        ESPECIALIZADO LEGAL</option>
                                    <option value="PROFESIONAL SEGUIMIENTO PROYECTO INGICAT - ECOPETR...">PROFESIONAL
                                        SEGUIMIENTO PROYECTO INGICAT - ECOPETR...</option>
                                    <option value="GERENTE PROYECTO">GERENTE PROYECTO</option>
                                    <option value="ANALISTA TI">ANALISTA TI</option>
                                </select>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="edit_activo"
                                    class="block mb-2 text-sm font-medium text-gray-900">Activo</label>
                                <select name="edit_activo" id="edit_activo"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5">
                                    {{-- <option selected="">Seleccionar</option> --}}
                                    <option value="Administrativo ECP">Administrativo ECP</option>
                                    <option value="Apiay">Apiay</option>
                                    <option value="Casabe">Casabe</option>
                                    <option value="Castilla">Castilla</option>
                                    <option value="Catenare">Catenare</option>
                                    <option value="Chichimene">Chichimene</option>
                                    <option value="CPO9">CPO9</option>
                                    <option value="ELC-GRB">ELC-GRB</option>
                                    <option value="Floreña">Floreña</option>
                                    <option value="Invasiones">Invasiones</option>
                                    <option value="Lisama">Lisama</option>
                                    <option value="Llanito">Llanito</option>
                                    <option value="Nacional">Nacional</option>
                                    <option value="Provincia">Provincia</option>
                                    <option value="Transversal">Transversal</option>
                                </select>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="edit_vicepresidencia"
                                    class="block mb-2 text-sm font-medium text-gray-900">Vicepresidencia</label>
                                <select name="edit_vicepresidencia" id="edit_vicepresidencia"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5">
                                    {{-- <option selected="">Seleccionar categoria</option> --}}
                                    <option value="Administrativo">Administrativo</option>
                                    <option value="Invasiones">Invasiones</option>
                                    <option value="Nacional">Nacional</option>
                                    <option value="Transversal">Transversal</option>
                                    <option value="VPI">VPI</option>
                                    <option value="VRC">VRC</option>
                                    <option value="VRO">VRO</option>
                                </select>
                            </div>

                            <div class="col-span-6 sm:col-span-3">
                                <label for="edit_gerencia"
                                    class="block mb-2 text-sm font-medium text-gray-900">Gerencia</label>
                                <select name="edit_gerencia" id="edit_gerencia"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5">
                                    {{-- <option selected="">Seleccionar categoria</option> --}}
                                    <option value="Administrativo">Administrativo</option>
                                    <option value="GCH">GCH</option>
                                    <option value="GDP">GDP</option>
                                    <option value="GDT">GDT</option>
                                    <option value="GLC">GLC</option>
                                    <option value="GMA">GMA</option>
                                    <option value="GRI">GRI</option>
                                    <option value="GTA">GTA</option>
                                    <option value="Invasiones">Invasiones</option>
                                    <option value="Nacional">Nacional</option>
                                    <option value="Transversal">Transversal</option>
                                </select>
                            </div>
                            <div class="col-span-6 sm:col-span-3">
                                <label for="edit_ubicacion"
                                    class="block mb-2 text-sm font-medium text-gray-900">Ubicacion</label>
                                <select name="edit_ubicacion" id="edit_ubicacion"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5">
                                    <option selected="">Seleccionar categoria</option>
                                    <option value="ACACIAS">ACACIÁS</option>
                                    <option value="BARRANCABERMEJA">BARRANCABERMEJA</option>
                                    <option value="BOGOTÁ">BOGOTÁ</option>
                                    <option value="VILLAVICENCIO">VILLAVICENCIO</option>
                                    <option value="YOPAL">YOPAL</option>
                                    <option value="TRABAJO EN CASA">TRABAJO EN CASA</option>
                                </select>
                            </div>
                        </div>
                </div>
                <!-- Modal footer -->
                <div class="items-center p-6 border-t border-gray-200 rounded-b">
                    <button
                        class="text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center"
                        type="submit">Guardar</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Importar Modal -->
    <div id="importUserModal" tabindex="-1" aria-hidden="true" class="fixed inset-0 hidden z-50 overflow-y-auto">
        <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
        <div class="flex items-center justify-center min-h-screen">
            <div class="relative w-full max-w-lg rounded-lg shadow bg-white">
                <div class="flex items-start justify-between p-4 border-b rounded-t">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-black">
                        Importar lista de usuarios
                    </h3>
                    <button type="button" id="closeImportUserModal"
                        class="text-black bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center"
                        data-modal-target="importUserModal" data-modal-toggle="importUserModal">
                        <svg class="w-5 h-5" fill="currentColor" viewbox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                clip-rule="evenodd" />
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <div class="p-6 space-y-6">
                    <form action="{{ route('usuario.import') }}" method="POST" enctype="multipart/form-data"
                        id="importarArchivo">
                        @csrf
                        <div>
                            <label for="archivo_csv" class="block text-sm font-medium leading-6 text-gray-900">Archivo
                                CSV</label>
                            <div class="mt-2">
                                <input
                                    class="mt-2 block w-full text-sm text-gray-700 bg-white border border-gray-300 rounded-lg cursor-pointer focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-red-500 file:text-white hover:file:bg-red-600"
                                    id="archivo_csv" name="archivo_csv" type="file">
                            </div>
                            <br>
                            <a href="{{ asset('plantillas/usuarios.csv') }}"
                                class="text-blue-600 hover:underline dark:text-blue-500">Plantilla CSV -
                                usuarios</a>
                        </div>
                        <div class="w-full flex justify-between mt-4">
                            <button type="submit"
                                class="w-1/3 bg-red-700 text-white py-2 rounded-md shadow-sm hover:bg-red-800">Importar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="{{ asset('js/usuarios.js') }}"></script>
    <script>
        $('#importarArchivo').on('submit', function(e) {
            e.preventDefault();

            let formData = new FormData(this);

            $.ajax({
                type: 'POST',
                url: '{{ route('usuario.import') }}',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Éxito',
                            text: response.success,
                        }).then(() => {
                            location.reload();
                        });
                    } else if (response.warning && response.download) {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Usuarios duplicados',
                            text: response.warning,
                            confirmButtonText: 'Descargar archivo'
                        }).then(() => {
                            window.location.href = response.download;

                            // Esperamos 2 segundos para recargar después de iniciar descarga
                            setTimeout(() => {
                                location.reload();
                            }, 2000);
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Ocurrió un problema al importar el archivo.',
                    });
                }
            });
        });
    </script>

</body>

</html>
