<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <title>Bienvenido</title>
</head>

<body>
    @include('layout.header')

    <div class="container mx-auto p-8">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <!-- Tarjeta de Bienvenida -->
            <div class="bg-white shadow-xl rounded-lg p-8">
                <div class="flex items-center space-x-6 mb-4">
                    <i class="fas fa-home text-blue-600 text-4xl"></i>
                    <h2 class="text-lg font-bold">¡Hola y bienvenido al aplicativo de sistema de gestión de reportes
                        INGICAT!</h2>
                </div>
                <p class="text-gray-700 text-sm">

                    Este aplicativo está diseñado para ayudarte a gestionar y registrar tus actividades diarias de
                    manera sencilla y eficiente. Aquí podrás llevar un control detallado de tus tareas, hacer
                    seguimiento de tu progreso y obtener reportes que te ayudarán a optimizar los tiempos de tu gestión.

                </p>

                <p class="text-gray-700 text-sm mt-4">
                    Para comenzar, explora las distintas funcionalidades y configura tu perfil según tus necesidades. Si
                    en algún momento necesitas ayuda o tienes preguntas, nuestra guía de usuario y el equipo de soporte
                    están disponibles para asistirte.
                </p>

                <div class=" justify-center items-center w-24 h-24 mx-auto mt-8">
                    <img src="images/ingicat.png" alt="logo" class="object-contain w-24 h-24">
                </div>
            </div>

            <!-- Tarjeta de Descripción Básica -->
            <div class="bg-white shadow-xl rounded-lg p-8">
                <div class="flex items-center space-x-6 mb-4">
                    <i class="fas fa-info-circle text-green-600 text-4xl"></i>
                    <h2 class="text-lg font-bold">Instrucciones básicas para usar el sistema.</h2>
                </div>
                <ul class="text-gray-700 text-sm  pl-8 space-y-2">
                    <li><i class="fa-solid fa-arrow-right"></i> Inicio: <span class="font-semibold">
                            Página principal con las instrucciones de uso.
                        </span></li>

                    <li><i class="fa-solid fa-arrow-right"></i> Reporte: <span class="font-semibold">
                            Este botón de reporte te llevará a la página de Reportes, allí podrás registrar y gestionar
                            tus tareas a
                            través de un sistema fácil de usar.
                        </span></li>

                    <li><i class="fa-solid fa-arrow-right"></i> Sistema de tareas: <span class="font-semibold">
                            En el apartado Registrar Tarea podrás crear tareas que se registraran en tu reporte de
                            producto
                            y/o reporte de tiempo, puedes elegir el producto, agregar la fecha, el código Fn, Código
                            SIG, el Servicio, la ubicación y la descripción, todos los campos son obligatorios. Si algún
                            dato no aplica, por favor agregar N/A. Tendrás la posibilidad de generar el reporte en
                            cualquier momento.
                        </span></li>

                    <li><i class="fa-solid fa-arrow-right"></i> Lista de Tareas:<span class="font-semibold">
                            En el apartado de lista de tarea obtendrá una serie de datos relacionados con las tareas,
                            estas tareas contienen los siguientes datos: producto, fecha, FN, código SIG, descripción y
                            finalmente existen dos botones "editar" y "novedad".
                        </span></li>

                    <li><i class="fa-solid fa-arrow-right"></i>Editar: <span class="font-semibold">
                            En el botón de editar el usuario podrá cambiar ciertos datos de los productos, además de
                            eliminarlos en caso de ser necesario.
                        </span></li>

                    <li><i class="fa-solid fa-arrow-right"></i>Novedad: <span class="font-semibold">
                            En este botón podrá generar novedades, entre estas es posible extender tareas, terminar
                            tarea y finalmente esta la opción de registrar una tarea como un producto.
                        </span>
                    </li>

                    <li><i class="fa-solid fa-arrow-right"></i>Historial: <span class="font-semibold">
                            En el apartado de historial esta el historial de reportes de tiempo y reportes de producto,
                            en este generaran listas con los datos en el periodo de tiempo filtrado y permite la edicion
                            y eliminacion de datos.
                        </span></li>

                    <li><i class="fa-solid fa-arrow-right"></i><span class="font-semibold">
                            En el icono de usuario en la parte superior, podrá cambiar su contraseña y cerrar la sesión.
                        </span></li>
                </ul>
            </div>
        </div>
    </div>
</body>

</html>
