<?php

use App\Http\Controllers\AgregarProductoController;
use App\Http\Controllers\AsignacionFnController;
use App\Http\Controllers\ReporteProductoController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CodigoSigController;
use App\Http\Controllers\ConfigurarController;
use App\Http\Controllers\TimesController;
use App\Http\Controllers\CvsController;
use App\Http\Controllers\DescargaController;
use App\Http\Controllers\DescargaRevisionController;
use App\Http\Middleware\NoCache;
use App\Http\Middleware\CheckRole;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProdExportController;
use App\Http\Controllers\RecuperarController;
use App\Http\Controllers\RegistrosController;
use App\Http\Middleware\RedirectIfSessionExpired;
use App\Http\Controllers\ListaController;
use App\Http\Controllers\RecepcionController;
use App\Http\Controllers\EnviarController;
use App\Http\Controllers\tareaController;
use App\Http\Controllers\UsuariosController;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\EncuestaController;
use App\Http\Controllers\exportController;
use App\Http\Controllers\adminEncuestaController;


// Login
Route::get('/', [AuthController::class, 'login'])->name('login')->middleware(NoCache::class);
Route::post('/', [AuthController::class, 'authenticate'])->name('auth.authenticate')->middleware(NoCache::class);

//recuperación de contraseña.
Route::get('/recuperar', [RecuperarController::class, 'index'])->name('auth.index');
Route::post('/recuperar/enviar', [RecuperarController::class, 'enviarCorreo'])->name('recuperar.enviar');

Route::middleware(['auth', NoCache::class, RedirectIfSessionExpired::class])->group(
    function () {
        Route::get('/inicio', function () {
            return view('welcom');
        })->name('inicio');

        Route::get('/reporte-producto', [ReporteProductoController::class, 'index'])->name('producto'); //vista del formulario de reporte de producto

        Route::post('/reporte-producto/productos', [ReporteProductoController::class, 'getProductosBySector']);

        Route::post('/reporte-producto/categoria', [ReporteProductoController::class, 'getCategoria']);

        Route::post('/reporte-producto/servicio', [ReporteProductoController::class, 'getServicio']);

        // Route::post('/reporte-producto', [ReporteProductoController::class, 'store'])->name('producto.store');

        Route::post('/reporte/store', [ReporteProductoController::class, 'store'])->name('producto.store');

        Route::post('/tiempo/store', [ReporteProductoController::class, 'storeTime']);


        Route::get('/producto/{id}', [ReporteProductoController::class, 'edit'])->name('producto.edit');

        Route::put('/producto/{id}/update', [ReporteProductoController::class, 'update'])->name('producto.update');

        Route::put('/producto/{id}/extender', [ReporteProductoController::class, 'extend'])->name('extender');

        Route::get('/productsheet', [ProdExportController::class, 'index'])->name('productsheet');

        Route::get('/sheet', [TimesController::class, 'index'])->name('index');

        Route::post('/timesheet', [TimesController::class, 'export'])->name('timesheet');

        Route::post('/export', [ProdExportController::class, 'export'])->name('export');

        /*         Route::get('/report/{id}', [ReporteProductoController::class,'actualizar'])->name('actualizar'); */
        Route::put('/producto/{id}/actualizar', [ReporteProductoController::class, 'actualizar'])->name('actualizar');
        Route::delete('/producto/{id}/eliminar', [ReporteProductoController::class, 'eliminar'])->name('eliminar');
        Route::put('/producto/{id}/terminar', [ReporteProductoController::class, 'terminar'])->name('terminar');

        Route::get('/listado', [ListaController::class, 'lista'])->name('lista');
        Route::get('/edicion/{id}', [ListaController::class, 'edicion'])->name('edicion');
        Route::put('/actualizacion/{id}', [ListaController::class, 'actualizacion'])->name('actualizacion');
        Route::delete('/dell/{id}', [ListaController::class, 'dell'])->name('dell');

        Route::get('/history', [tareaController::class, 'index'])->name('history');
        Route::get('/historyedith/{id}', [tareaController::class, 'historyedith'])->name('historyedith');
        Route::put('/historyact/{id}', [tareaController::class, 'historyact'])->name('historyact');
        Route::delete('/delle/{id}', [tareaController::class, 'delle'])->name('delle');


        Route::get('/Enviar', [EnviarController::class, 'index'])->name('enviar');
        Route::post('/Enviar-correo', [EnviarController::class, 'enviar'])->name('correo.enviar');


        Route::get('/recepcion', [RecepcionController::class, 'index'])->name('recepcion');
        Route::put('/recepcion/{id}', [RecepcionController::class, 'update'])->name('recepcion.update');

        Route::get('/configuracion', [ConfigurarController::class, 'index'])->name('configurar');
        Route::post('/configuracion', [ConfigurarController::class, 'save'])->name('cambiarClave.update');
        Route::put('/configuracion/actualizar-datos', [ConfigurarController::class, 'actualizarDatos'])->name('configuracion.actualizar');

        
        Route::get('/hse', [EncuestaController::class, 'mostrarEncuestasPorCategoria'])->name('hse.ver');
        Route::get('/responder/{categoria}', [EncuestaController::class, 'verPorCategoria'])->name('encuestas.categoria');
        Route::get('/encuesta/{id}/responder', [EncuestaController::class, 'responder'])->name('encuesta.responder');
        Route::post('/encuesta/{id}/responder', [EncuestaController::class, 'guardarRespuestas'])->name('encuesta.guardar');
    }
);

Route::middleware(['auth', NoCache::class, CheckRole::class, RedirectIfSessionExpired::class])->group(
    function () {

        // registros de usuarios, vista del formulario, registros, editar y eliminar algunos usuarios
        Route::get('/usuario', [UsuariosController::class, 'index'])->name('usuario');
        Route::post('/usuario', [UsuariosController::class, 'store'])->name('usuario.store');
        Route::get('/actualizar/{id}', [UsuariosController::class, 'edit'])->name('usuario.edit');
        Route::put('/actualizar/{id}', [UsuariosController::class, 'update'])->name('usuario.update');
        Route::post('/usuarios/importar', [UsuariosController::class, 'import'])->name('usuario.import'); // importar usuario desde un archivo
        Route::get('/descargar-duplicados', function () {
            $export = session('duplicados_export');
            $filename = session('duplicados_filename');

            if (!$export || !$filename) {
                abort(404);
            }

            session()->forget('duplicados_export');
            session()->forget('duplicados_filename');

            return Excel::download($export, $filename);
        })->name('usuarios.duplicados.descargar');

        Route::post('/usuario/{id}/estado', [UsuariosController::class, 'cambiarEstado']);


        //rutas de aprobador, mostrar vista, registrar y eliminar.

        Route::get('/registros', [RegistrosController::class, 'index'])->name('registros');

        Route::post('/registros/nuevo', [RegistrosController::class, 'store'])->name('aprobador.store');

        Route::delete('/registros/{identification}', [RegistrosController::class, 'destroy'])->name('registros.destroy');


        //rutas de asignacion de fn, index, store, destroy import..

        Route::get('/asignacion-fn', [AsignacionFnController::class, 'index'])->name('asignacion');

        Route::post('/registros/new', [AsignacionFnController::class, 'new'])->name('nuevo.store');

        Route::delete('/registro/{identification}/{fn}', [AsignacionFnController::class, 'destroyFn'])->name('registro.destroy');

        Route::post('/import-fn', [AsignacionFnController::class, 'import'])->name('import.fn');

        //fn y codigo sig
        Route::get('/fn-sig', [CodigoSigController::class, 'index'])->name('sig.index');

        Route::post('/fn-sig/registro', [CodigoSigController::class, 'store'])->name('sig.store');

        Route::post('/fn-sig/import', [CodigoSigController::class, 'import'])->name('sig.import');

        Route::delete('/fn-sigs/{id}', [CodigoSigController::class, 'destroy'])->name('sig.destroy');

        //Descarga de producto masivo, pms

        Route::get('/descargas', [DescargaController::class, 'index'])->name('descarga.index');

        Route::post('/descargas/export', [DescargaController::class, 'export'])->name('descargar.export');

        Route::post('/descargas/masivo', [DescargaController::class, 'masivo'])->name('masivo.export');

        Route::post('/descargas/pms', [DescargaController::class, 'pms'])->name('pms.export');

        //exportar revision
        Route::get('/revision', [DescargaRevisionController::class, 'index'])->name('revision');
        Route::post('/revision/masivo', [DescargaRevisionController::class, 'masivo'])->name('masivo.revision');

        //agregar producto y categoria
        Route::get('/agregar-producto', [AgregarProductoController::class, 'index'])->name('agregar.index');
        Route::post('/agregar-producto/registro', [AgregarProductoController::class, 'store'])->name('agregar.store');
        Route::delete('/agregar-producto/registro/{id}', [AgregarProductoController::class, 'destroy'])->name('agregar.destroy');

        // Encuestas

        Route::get('/hse/crear', [EncuestaController::class, 'crear'])->name('hse.crear');
        Route::post('/hse/guardar', [EncuestaController::class, 'guardar'])->name('hse.guardar');


        Route::get('/hse/exportar', [exportController::class, 'index'])->name('exportar.index');
        //Route::get('/hse/exportar/encuesta', [exportController::class, 'export'])->name('export.encuesta');
        Route::get('/hse/administrar', [adminEncuestaController::class, 'index'])->name('admin.encuesta');
        Route::put('/hse/administrar/estado/{id}', [adminEncuestaController::class, 'cambiarEstado'])->name('admin.estado'); 
        Route::delete('/hse/administrar/eliminar/{id}', [adminEncuestaController::class, 'eliminar'])->name('admin.eliminar');
        Route::GET('/hse/exportar/masivo/{id}', [adminEncuestaController::class, 'masivo'])->name('export.masivo');
        Route::post('/hse/exportar/individual/{id}', [adminEncuestaController::class, 'individual'])->name('export.individual');
        Route::post('/hse/exportar/fecha/{id}', [adminEncuestaController::class, 'fecha'])->name('export.fecha');
    }
);

// Logout
Route::post('/logout', [AuthController::class, 'logout'])->name('auth.logout')->middleware(NoCache::class);
