<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="<?php echo e(asset('images/ingicat.png')); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <title>Descargar - Reportes producto</title>

</head>

<body>
    <?php echo $__env->make('layout.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <div class="container w-11/12 mx-auto py-12">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">

            <div class="bg-white shadow-xl rounded-lg p-8">
                <form action="<?php echo e(route('descargar.export')); ?>" id="descarForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <h2 class="text-lg font-bold">Reporte de trabajador</h2>
                    <div class="grid grid-cols-1 md:grid-cols-1 gap-8">
                        <div class="m-1">
                            <label for="fecha" class="block text-sm font-medium text-gray-900">Fecha</label>
                            <input type="month" name="fecha" id="fecha" required
                                class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2">
                        </div>
                        <div class="m-1">
                            <label for="buscar" class="block text-sm font-medium text-gray-900">Documento</label>
                            <input type="number" name="buscar" id="buscar" required placeholder="123456789"
                                class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2">
                        </div>
                        <div class="m-1">
                            <button
                                class="fecha-btn2 mt-6 rounded-md bg-red-800 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">Descargar
                                de empleado</button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="bg-white shadow-xl rounded-lg p-8">
                <form action="<?php echo e(route('masivo.export')); ?>" id="masivoForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <h2 class="text-lg font-bold">Reporte productos masivo de trabajadores</h2>
                    <div class="grid grid-cols-1 md:grid-cols-1 gap-8">
                        <div class="mt-1">
                            <label for="fecha2" class="block text-sm font-medium text-gray-900">Desde:</label>
                            <input type="date" name="fecha2" id="fecha2" required
                                class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2">
                        </div>
                        <div class="m-1">
                            <label for="fecha3" class="block text-sm font-medium text-gray-900">Hasta:</label>
                            <input type="date" name="fecha3" id="fecha3" required
                                class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2">
                        </div>
                        <div class="m-1">
                            <button
                                class="masivo-btn mt-6 rounded-md bg-red-800 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">Descargar
                                reporte masivo</button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="bg-white shadow-2xl rounded-lg p-8 mt-4">
                <form action="<?php echo e(route('pms.export')); ?>" id="masivoFormPms" method="POST">
                    <?php echo csrf_field(); ?>
                    <h2 class="text-lg font-bold">Reporte productos masivo de PMS</h2>
                    <div class="grid grid-cols-1 md:grid-cols-1 gap-8">
                        <div class="mt-1">
                            <label for="fecha4" class="block text-sm font-medium text-gray-900">Desde:</label>
                            <input type="date" name="fecha4" id="fecha4" required
                                class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2">
                        </div>
                        <div class="m-1">
                            <label for="fecha5" class="block text-sm font-medium text-gray-900">Hasta:</label>
                            <input type="date" name="fecha5" id="fecha5" required
                                class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2">
                        </div>
                        <div class="m-1">
                            <button
                                class="masivo-btn mt-6 rounded-md bg-red-800 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">Descargar
                                reporte masivo</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php if($errors->any()): ?>
        <script>
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: '<?php echo e($errors->first()); ?>',
            });
        </script>
    <?php endif; ?>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\sistema-reportes\resources\views/descargas.blade.php ENDPATH**/ ?>