<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="<?php echo e(asset('images/ingicat.png')); ?>">
    <title>crear</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <link rel="stylesheet" href="<?php echo e(asset('fontawesome/css/all.min.css')); ?>">
</head>

<body>
    <?php echo $__env->make('layout.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <div class="container w-11/12 mx-auto py-12">
        <div class="relative overflow-hidden bg-white shadow-md sm:rounded-lg">
            <div class="flex flex-col px-4 py-3 space-y-3 lg:flex-row lg:items-center lg:justify-between lg:space-y-0 lg:space-x-4">
                <div class="flex items-center flex-1 space-x-4">
                    <form class="lg:pr-3" action="<?php echo e(route('admin.encuesta')); ?>" method="GET">
                        <label for="EncuestaBus" class="sr-only">Search</label>
                        <div class="relative mt-1 lg:w-64 xl:w-96">
                           <input type="text" name="EncuestaBus" id="EncuestaBus"
                            value="<?php echo e(request('EncuestaBus')); ?>"
                            class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5"
                            placeholder="Nombre de la encuesta">

                        </div>
                    </form>
                </div>
            </div>
            <div id="TableEncuesta">
                <?php echo $__env->make('partials.tablaEncuesta', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
    </div>



</body>
<script>
    let timeout = null;
    const input = document.getElementById('EncuestaBus');

    input.addEventListener('input', function () {
        clearTimeout(timeout);
        timeout = setTimeout(() => {
            this.form.submit();
        }, 500); // Espera 500 ms después de que el usuario deja de escribir
    });
</script>
</html>
<?php /**PATH C:\xampp\htdocs\sistema-reportes\resources\views/hse/adminEncuesta.blade.php ENDPATH**/ ?>