<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="<?php echo e(asset('images/ingicat.png')); ?>">
    <title>inicio</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <link rel="stylesheet" href="<?php echo e(asset('fontawesome/css/all.min.css')); ?>">
</head>

<body>
    <?php echo $__env->make('layout.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 p-6">
       <?php $__currentLoopData = $encuestasAgrupadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria => $encuestas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($encuestas->count() > 0): ?>
                <?php
                    $imagenes = [
                        'actos y condiciones inseguras' => 'Seguridad.png',
                        'conversaciones y reflexiones' => 'Conversaciones.png',
                        'momento hse' => 'Momento.png',
                        'campañas' => 'Campaña.png',
                        'alertas hse ecp' => 'Alerta.png',
                        'capacitaciones' => 'Capacitaciones.jpg',
                    ];

                    $nombreCategoria = strtolower($categoria);
                    $imagen = $imagenes[$nombreCategoria] ?? 'default.png'; // Imagen por defecto si no hay coincidencia
                ?>

                <a href="<?php echo e(route('encuestas.categoria', ['categoria' => $categoria])); ?>">
                    <div class="bg-gray-100 border hover:shadow-xl transition rounded-2xl p-6 cursor-pointer text-center">
                        <img src="<?php echo e(asset('images/' . $imagen)); ?>" alt="<?php echo e($categoria); ?>" class="mx-auto mb-3 w-16 h-16 object-contain">
                        <h3 class="text-lg font-bold text-gray-700"><?php echo e($categoria); ?></h3>
                        <p class="text-sm text-gray-600"><?php echo e($encuestas->count()); ?> encuesta(s) disponible(s)</p>
                    </div>
                </a>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\sistema-reportes\resources\views/hse/inicio.blade.php ENDPATH**/ ?>