<div class="overflow-x-auto">
    <table class="w-full text-sm text-left text-gray-500 ">
        <thead class="text-xs text-gray-700 uppercase bg-gray-50 ">
            <tr>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">
                    Titulo</th>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">descripcion
                </th>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">
                    frecuencia</th>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">
                    Categoria</th>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">
                    Estado</th>
                <th scope="col" class="px-4 py-3 font-medium text-left text-gray-500 uppercase">
                    Accion</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $encuestas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $encuesta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="border-b hover:bg-gray-100">
                    <td class="flex items-center p-4 mr-12 space-x-6 whitespace-nowrap">
                        <div class="text-sm font-normal text-gray-500 ">
                            <div class="text-base font-semibold text-gray-900">
                                <?php echo e($encuesta->titulo); ?></div>
                        </div>
                    </td>
                    <td class="p-4 text-base font-medium text-gray-900 whitespace-nowrap">
                          <?php echo e(Str::limit($encuesta->descripcion, 50)); ?> </td>
                    <td class="p-4 text-base font-medium text-gray-900 whitespace-nowrap">
                        <?php echo e($encuesta->frecuencia); ?></td>
                    <td class="p-4 text-base font-medium text-gray-900 whitespace-nowrap">
                        <?php echo e($encuesta->categoria); ?></td>
                    <td class="p-4 text-base font-normal text-gray-900 whitespace-nowrap">
                        <div class="flex items-center">
                            <div
                                class="h-2.5 w-2.5 rounded-full mr-2 <?php echo e($encuesta->state == '1' ? 'bg-green-500' : 'bg-red-500'); ?>">
                            </div>
                            <?php echo e($encuesta->activa == '1' ? 'Activo' : 'Inactivo'); ?>

                        </div>
                    </td>
                <td class="p-4 space-x-2 whitespace-nowrap">
                        <button type="button"
                            class="bg-blue-600 edit-btn inline-flex items-center px-3 py-2 text-sm font-medium text-white rounded-lg hover:bg-blue-700 focus:ring-4 focus:ring-blue-300 open-download-menu-btn"
                            data-id="<?php echo e($encuesta->id); ?>">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M17.414 2.586a2 2 0 00-2.828 0L7 10.172V13h2.828l7.586-7.586a2 2 0 000-2.828z"></path>
                                <path fill-rule="evenodd"
                                    d="M2 6a2 2 0 012-2h4a1 1 0 010 2H4v10h10v-4a1 1 0 112 0v4a2 2 0 01-2 2H4a2 2 0 01-2-2V6z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            Descargar
                        </button>
                    
                        
                        <button type="button" onclick="toggleUserStatus(<?php echo e($encuesta->id); ?>, <?php echo e($encuesta->activa == 1 ? 0 : 1); ?>)"
                            class="inline-flex items-center px-3 py-2 text-sm font-medium text-center text-white <?php echo e($encuesta->state == '1' ? 'bg-yellow-600 rounded-lg hover:bg-yellow-800 focus:ring-4 focus:ring-yellow-300' : 'bg-green-600 rounded-lg hover:bg-green-800 focus:ring-4 focus:ring-green-300'); ?>">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 22"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12ZM12 8.25a.75.75 0 0 1 .75.75v3.75a.75.75 0 0 1-1.5 0V9a.75.75 0 0 1 .75-.75Zm0 8.25a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            <?php echo e($encuesta->activa == '1' ? 'Desactivar' : 'Activar'); ?>

                        </button>
                        <!-- Botón Eliminar (ligeramente más grande) -->
                        <button type="button"
                            onclick="eliminarEncuesta(<?php echo e($encuesta->id); ?>)"
                            class="ml-2 inline-flex items-center px-3 py-2 text-sm font-medium text-white bg-red-600 rounded-lg hover:bg-red-700 focus:ring-4 focus:ring-red-300">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M6 2a1 1 0 00-1 1v1H3.5a.5.5 0 000 1H4v11a2 2 0 002 2h8a2 2 0 002-2V5h.5a.5.5 0 000-1H15V3a1 1 0 00-1-1H6zm2 4a1 1 0 012 0v8a1 1 0 11-2 0V6zm4 0a1 1 0 012 0v8a1 1 0 11-2 0V6z"
                                    clip-rule="evenodd" />
                            </svg>
                            Eliminar
                        </button>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<!-- Modal de descarga -->
<div id="downloadMenu" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white p-6 rounded shadow-lg w-96">
        <h2 class="text-lg font-bold mb-4">Opciones de descarga</h2>

        <label for="downloadType" class="block mb-2 text-sm font-medium text-gray-700">Tipo de descarga</label>
        <select id="downloadType" class="w-full mb-4 border rounded px-2 py-1">
            <option value="">-- Selecciona una opción --</option>
            <option value="individual">Descargar encuesta individual</option>
            <option value="masiva">Descargar encuesta masiva</option>
            <option value="periodo">Descargar por periodo de tiempo</option>
        </select>

        <div id="individualForm" class="hidden">
            <form action="" method="POST"> 
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" class="encuesta-id-input" value="">
                <label for="documento" class="block text-sm font-medium">Documento de Identidad</label>
                <input type="text" id="documento" name="documento" class="w-full mt-1 mb-3 border rounded px-2 py-1" />
                <button type="submit" class="bg-blue-600 text-white px-3 py-1 rounded hover:bg-blue-700 w-full">Descargar</button>
            </form>
        </div>

        <div id="masivaForm" class="hidden">
            <form action="" method="GE  T" id="masivaDownloadForm"> 
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" class="encuesta-id-input" value=""> 
                <p class="text-gray-700 mb-3">Se descargará toda la información disponible.</p>
                <button type="submit" class="bg-green-600 text-white px-3 py-1 rounded hover:bg-green-700 w-full">Descargar Todo</button>
            </form>
        </div>

        <div id="periodoForm" class="hidden">
            <form action="" method="POST" id="periodoDownloadForm"> 
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" class="encuesta-id-input" value=""> 
                <label class="block text-sm font-medium">Fecha inicial</label>
                <input type="date" id="fechaInicio" name="fecha_inicio" class="w-full mt-1 mb-2 border rounded px-2 py-1" />

                <label class="block text-sm font-medium">Fecha final</label>
                <input type="date" id="fechaFin" name="fecha_fin" class="w-full mt-1 mb-3 border rounded px-2 py-1" />

                <button type="submit" class="bg-purple-600 text-white px-3 py-1 rounded hover:bg-purple-700 w-full">Descargar por periodo</button>
            </form>
        </div>

        <button id="closeDownloadMenu" class="text-red-500 mt-4 hover:underline">Cancelar</button>
    </div>
</div>
<div class="pagination">
    <?php echo $encuestas->links(); ?>

</div>
<script>
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

    // desactivar usuario
    function toggleUserStatus(encuestaId, newState) {
        const accion = newState === 0 ? 'inhabilitalo' : 'habilitalo';
        const textoExito = `La encuesta ha sido ${accion} correctamente.`;

        Swal.fire({
            title: '¿Estás seguro?',
            text: `¿Deseas ${accion} esta encuesta?`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: newState === 0 ? '#28a745' : '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: `Sí, ${accion}`,
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch(`/hse/administrar/estado/${encuestaId}`, {
                    method: 'PUT',
                    headers: {
                        'X-CSRF-TOKEN': csrfToken,
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ state: newState })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            Swal.fire('¡Éxito!', textoExito, 'success')
                                .then(() => location.reload());
                        } else {
                            Swal.fire('Error', data.message || 'No se pudo cambiar el estado.', 'error');
                        }
                    })
                    .catch(() => {
                        Swal.fire('Error', 'Error del servidor.', 'error');
                    });
            }
        });
    }

    function eliminarEncuesta(encuestaId) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: 'Esta acción eliminará la encuesta permanentemente.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/hse/administrar/eliminar/${encuestaId}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('¡Eliminada!', 'La encuesta ha sido eliminada.', 'success')
                        .then(() => location.reload());
                } else {
                    Swal.fire('Error', data.message || 'No se pudo eliminar la encuesta.', 'error');
                }
            })
            .catch(() => {
                Swal.fire('Error', 'Error del servidor al eliminar.', 'error');
            });
        }
    });
}


    document.addEventListener('DOMContentLoaded', () => {
        // Selecciona todos los botones con la clase 'open-download-menu-btn'
        const openDownloadButtons = document.querySelectorAll('.open-download-menu-btn');
        const downloadMenu = document.getElementById('downloadMenu');
        const closeDownloadMenu = document.getElementById('closeDownloadMenu');
        const downloadTypeSelect = document.getElementById('downloadType');
        const individualForm = document.getElementById('individualForm');
        const masivaForm = document.getElementById('masivaForm');
        const periodoForm = document.getElementById('periodoForm');

        openDownloadButtons.forEach(button => {
            button.addEventListener('click', (event) => {
                const encuestaId = event.currentTarget.getAttribute('data-id');

                // Establece la URL de acción correcta para el formulario masivo
                const masivaDownloadForm = document.getElementById('masivaDownloadForm');
                masivaDownloadForm.action = `/hse/exportar/masivo/${encuestaId}`; // Asumiendo que tu ruta espera el ID en la URL

                // Establece la URL de acción correcta para el formulario individual
                const individualDownloadForm = individualForm.querySelector('form');
                individualDownloadForm.action = `/hse/exportar/individual/${encuestaId}`; // Ajusta según tu ruta

                // Establece la URL de acción correcta para el formulario por periodo
                const periodoDownloadForm = periodoForm.querySelector('form');
                periodoDownloadForm.action = `/hse/exportar/fecha/${encuestaId}`; // Ajusta según tu ruta


                // Asigna el ID a TODOS los campos de entrada ocultos con la clase "encuesta-id-input"
                document.querySelectorAll('.encuesta-id-input').forEach(input => {
                    input.value = encuestaId;
                });

                // Reinicia el select y oculta todos los formularios al abrir el modal
                downloadTypeSelect.value = '';
                individualForm.classList.add('hidden');
                masivaForm.classList.add('hidden');
                periodoForm.classList.add('hidden');

                downloadMenu.classList.remove('hidden');
            });
        });

        closeDownloadMenu.addEventListener('click', () => {
            downloadMenu.classList.add('hidden');
        });

        downloadTypeSelect.addEventListener('change', (e) => {
            const value = e.target.value;
            individualForm.classList.add('hidden');
            masivaForm.classList.add('hidden');
            periodoForm.classList.add('hidden');

            if (value === 'individual') {
                individualForm.classList.remove('hidden');
            } else if (value === 'masiva') {
                masivaForm.classList.remove('hidden');
            } else if (value === 'periodo') {
                periodoForm.classList.remove('hidden');
            }
        });
    });
    
</script>

<?php /**PATH C:\xampp\htdocs\sistema-reportes\resources\views/partials/tablaEncuesta.blade.php ENDPATH**/ ?>